/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.debug.application;

import org.eclipse.cdt.debug.application.RemoteExecutableDialog;
import org.eclipse.cdt.debug.application.RemoteExecutableInfo;
import org.eclipse.cdt.internal.debug.application.DebugRemoteExecutable;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DebugRemoteExecutableHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RemoteExecutableDialog dialog = new RemoteExecutableDialog(new Shell());
        if (dialog.open() == 0) {
            RemoteExecutableInfo info = dialog.getExecutableInfo();
            String executable = info.getHostPath();
            String buildLog = info.getBuildLog();
            String address = info.getAddress();
            String port = info.getPort();
            boolean attach = info.isAttach();
            try {
                ILaunchConfiguration config = DebugRemoteExecutable.createLaunchConfig((IProgressMonitor)new NullProgressMonitor(), buildLog, executable, address, port, attach);
                if (config != null) {
                    Display.getDefault().syncExec(() -> DebugUITools.launch((ILaunchConfiguration)config, (String)"debug"));
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

