/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.managers;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.dbgp.IDbgpNotification;
import org.eclipse.dltk.dbgp.IDbgpNotificationListener;
import org.eclipse.dltk.dbgp.IDbgpNotificationManager;
import org.eclipse.dltk.dbgp.internal.DbgpNotification;
import org.eclipse.dltk.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.dbgp.internal.IDbgpDebugingEngine;
import org.eclipse.dltk.dbgp.internal.packets.DbgpNotifyPacket;

public class DbgpNotificationManager
extends DbgpWorkingThread
implements IDbgpNotificationManager {
    private final ListenerList<IDbgpNotificationListener> listeners = new ListenerList();
    private final IDbgpDebugingEngine engine;

    protected void fireDbgpNotify(IDbgpNotification notification) {
        for (IDbgpNotificationListener listener : this.listeners) {
            listener.dbgpNotify(notification);
        }
    }

    @Override
    protected void workingCycle() throws Exception {
        try {
            while (!Thread.interrupted()) {
                DbgpNotifyPacket packet = this.engine.getNotifyPacket();
                this.fireDbgpNotify(new DbgpNotification(packet.getName(), packet.getContent()));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public DbgpNotificationManager(IDbgpDebugingEngine engine) {
        super("DBGP - Notification Manager");
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
    }

    @Override
    public void addNotificationListener(IDbgpNotificationListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeNotificationListener(IDbgpNotificationListener listener) {
        this.listeners.remove((Object)listener);
    }
}

