/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.context;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.test.common.bitmaps.BundleState;

public final class ContextHelper {
    private ContextHelper() {
    }

    public static BundleContext getBundleContext(Class<?> testClass) {
        Bundle bundle = FrameworkUtil.getBundle(testClass);
        if (bundle == null) {
            throw new IllegalStateException(String.format("No BundleContext available - The class (%s) must be loaded from a bundle", testClass));
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            throw new IllegalStateException(String.format("No BundleContext available - The bundle of the class (%s) must be started to have a BundleContext; bundle current state: %s", testClass, BundleState.toString(bundle.getState())));
        }
        return context;
    }
}

