/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.JoinHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.AddTableAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.CreateJoinAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.DefineJoinTypeAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.TableAliasAction;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DeleteHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.InsertHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.UpdateHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ISQLEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.JoinEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.SQLRootEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.TableEditPart;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;

public class GraphContextMenuProvider
extends ContextMenuProvider {
    SQLDomainModel domainModel;
    VendorHelper vendorHelper;
    AddTableAction addTable;
    AddTableAction replaceSelectTable;
    RemoveSelectedTableAction removeTable;
    TableAliasAction tableAlias;
    CreateJoinAction createJoin;
    DefineJoinTypeAction defineJoinType;
    RemoveJoinAction removeJoin;
    SelectAllColumnsAction selectAll;
    DeselectAllColumnsAction deselectAll;
    SQLQueryObject statement;

    public GraphContextMenuProvider(EditPartViewer viewer, SQLDomainModel domainModel) {
        super(viewer);
        this.domainModel = domainModel;
        this.initActions();
        this.vendorHelper = new VendorHelper(domainModel.getDatabase());
    }

    protected void initActions() {
        this.addTable = new AddTableAction(this.domainModel);
        this.replaceSelectTable = new AddTableAction(this.domainModel);
        this.removeTable = new RemoveSelectedTableAction();
        this.tableAlias = new TableAliasAction(this.domainModel);
        this.createJoin = new CreateJoinAction(this.domainModel);
        this.defineJoinType = new DefineJoinTypeAction(this.domainModel);
        this.removeJoin = new RemoveJoinAction();
        this.selectAll = new SelectAllColumnsAction();
        this.deselectAll = new DeselectAllColumnsAction();
    }

    protected void addGlobalActionsAtStart(IMenuManager menu) {
        menu.add((IAction)this.addTable);
    }

    protected void addContextActions(IMenuManager menu, List selectedEditParts) {
        Iterator iter;
        EditPart part = null;
        if (selectedEditParts != null && (iter = selectedEditParts.iterator()).hasNext()) {
            part = (EditPart)iter.next();
        }
        if (part instanceof TableEditPart) {
            Object table = null;
            if (this.statement instanceof QuerySelectStatement) {
                QuerySelectStatement selectStmt;
                List tables;
                table = ((TableEditPart)part).getTable();
                if (table == null && ((TableEditPart)part).getModel() instanceof TableExpression) {
                    table = ((TableEditPart)part).getModel();
                }
                if ((tables = StatementHelper.getTablesForStatement((QueryStatement)(selectStmt = (QuerySelectStatement)this.statement))).size() > 1) {
                    this.createJoin.setSourceTable((TableExpression)tables.get(0));
                    menu.add((IAction)this.createJoin);
                }
                menu.add((IAction)this.replaceSelectTable);
                this.replaceSelectTable.setTable(table);
                menu.add((IAction)this.selectAll);
                this.selectAll.setTable(table);
                menu.add((IAction)this.deselectAll);
                this.deselectAll.setTable(table);
            } else if (this.statement instanceof QueryUpdateStatement || this.statement instanceof QueryDeleteStatement) {
                table = ((TableEditPart)part).getTable();
                this.addTable.setTable(table);
                if (this.statement instanceof QueryUpdateStatement) {
                    menu.add((IAction)this.selectAll);
                    this.selectAll.setTable(table);
                    menu.add((IAction)this.deselectAll);
                    this.deselectAll.setTable(table);
                }
            } else if (this.statement instanceof QueryInsertStatement) {
                table = ((TableEditPart)part).getTable();
                this.addTable.setTable(table);
                menu.add((IAction)this.selectAll);
                this.selectAll.setTable(table);
                menu.add((IAction)this.deselectAll);
                this.deselectAll.setTable(table);
            }
            if (!(this.statement instanceof QueryInsertStatement)) {
                TableExpression tableExpr = (TableExpression)((TableEditPart)part).getModel();
                if (!this.vendorHelper.isCloudscape() && !this.vendorHelper.isSybase() || !(this.statement instanceof QueryDeleteStatement)) {
                    this.tableAlias.setTable(tableExpr);
                    menu.add((IAction)this.tableAlias);
                }
                this.removeTable.setTable(tableExpr);
            }
            menu.add((IAction)this.removeTable);
            this.setCurrentStatement(this.statement);
        } else if (part instanceof JoinEditPart) {
            JoinEditPart joinPart = (JoinEditPart)part;
            this.defineJoinType.setSQLJoin(joinPart.getSQLJoin());
            this.removeJoin.setJoinPart(joinPart);
            menu.add((IAction)this.defineJoinType);
            menu.add((IAction)this.removeJoin);
        } else if (part instanceof SQLRootEditPart && (this.statement instanceof QueryUpdateStatement || this.statement instanceof QueryInsertStatement || this.statement instanceof QueryDeleteStatement)) {
            TableInDatabase stmtTable = null;
            if (this.statement instanceof QueryInsertStatement) {
                QueryInsertStatement insert = (QueryInsertStatement)this.statement;
                stmtTable = insert.getTargetTable();
            } else if (this.statement instanceof QueryUpdateStatement) {
                QueryUpdateStatement update = (QueryUpdateStatement)this.statement;
                stmtTable = update.getTargetTable();
            } else if (this.statement instanceof QueryDeleteStatement) {
                QueryDeleteStatement delete = (QueryDeleteStatement)this.statement;
                stmtTable = delete.getTargetTable();
            }
            this.addTable.setTable(stmtTable);
            this.setCurrentStatement(this.statement);
        } else {
            List tables;
            QueryExpressionBody queryExprBody;
            QuerySelectStatement selectStmt;
            QueryExpressionRoot root;
            this.addTable.setTable(null);
            if (this.statement instanceof QuerySelectStatement && (root = (selectStmt = (QuerySelectStatement)this.statement).getQueryExpr()) != null && (queryExprBody = root.getQuery()) != null && (tables = StatementHelper.getTableExpressionsInQueryExpressionBody((QueryExpressionBody)queryExprBody)).size() > 1) {
                this.createJoin.setSourceTable((TableExpression)tables.get(0));
                menu.add((IAction)this.createJoin);
            }
        }
    }

    protected SQLQueryObject getCurrentStatement() {
        return this.statement;
    }

    protected void setCurrentStatement(SQLQueryObject statement) {
        this.statement = statement;
        this.addTable.setElement(statement);
        this.replaceSelectTable.setElement(statement);
        this.tableAlias.setStatement(statement);
        this.createJoin.setStatement(statement);
    }

    protected void updateCurrentStatement(EditPartViewer viewer) {
        List editParts = viewer.getSelectedEditParts();
        for (EditPart part : editParts) {
            if (!(part instanceof ISQLEditPart)) continue;
            this.setCurrentStatement(((ISQLEditPart)part).getStatement());
            return;
        }
    }

    public void buildContextMenu(IMenuManager menu) {
        this.updateCurrentStatement(this.getViewer());
        this.addGlobalActionsAtStart(menu);
        this.addContextActions(menu, this.getViewer().getSelectedEditParts());
    }

    class DeselectAllColumnsAction
    extends Action {
        Object table;

        public DeselectAllColumnsAction() {
            super(Messages._UI_VIEWS_GRAPH_DESELECT_ALL_COLUMN);
        }

        public void setTable(Object table) {
            this.table = table;
        }

        public void run() {
            SQLQueryObject currStatement = GraphContextMenuProvider.this.getCurrentStatement();
            if (currStatement instanceof QuerySelectStatement || currStatement instanceof QuerySelect) {
                if (this.table instanceof Table) {
                    Table newTable = (Table)this.table;
                    for (Column col : newTable.getColumns()) {
                        ValueExpressionColumn colExpr = SelectHelper.getSelectColumnFromColumnName(currStatement, col.getName());
                        if (colExpr == null) continue;
                        SelectHelper.removeAllColumnFromResultColumns(currStatement, (QueryValueExpression)colExpr);
                    }
                }
                SelectHelper.refresh(currStatement);
            } else if (currStatement instanceof QueryInsertStatement) {
                QueryInsertStatement stmt = (QueryInsertStatement)currStatement;
                InsertHelper.removeAllColumnsAndValues(stmt);
            } else if (currStatement instanceof QueryUpdateStatement) {
                QueryUpdateStatement updateStatement = (QueryUpdateStatement)currStatement;
                UpdateHelper.clearAssignmentExprList(updateStatement);
            }
        }
    }

    class RemoveJoinAction
    extends Action {
        JoinEditPart joinPart;

        public RemoveJoinAction() {
            super(Messages._UI_ACTION_REMOVE_JOIN);
        }

        public void setJoinPart(JoinEditPart part) {
            this.joinPart = part;
        }

        public void run() {
            this.joinPart.removeJoin();
        }
    }

    class RemoveSelectedTableAction
    extends Action {
        TableExpression table;

        public RemoveSelectedTableAction() {
            super(Messages._UI_ACTION_REMOVE_TABLE_EDIT);
        }

        public void setTable(TableExpression table) {
            this.table = table;
        }

        public void run() {
            SQLQueryObject stmt = GraphContextMenuProvider.this.getCurrentStatement();
            if (stmt instanceof QuerySelectStatement || stmt instanceof QuerySelect) {
                String name = stmt.getName();
                String label = stmt.getLabel();
                TableJoined joinedTable = this.table.getTableJoinedLeft();
                if (joinedTable == null) {
                    joinedTable = this.table.getTableJoinedRight();
                }
                if (joinedTable != null) {
                    if (stmt instanceof QuerySelect) {
                        EList fromClauseList = ((QuerySelect)stmt).getFromClause();
                        JoinHelper.removeJoinsForTable((List)fromClauseList, (TableExpression)this.table);
                    } else if (stmt instanceof QuerySelectStatement) {
                        QuerySelect querySelect = SelectHelper.getQuerySelect((QuerySelectStatement)stmt);
                        EList fromClauseList = querySelect.getFromClause();
                        JoinHelper.removeJoinsForTable((List)fromClauseList, (TableExpression)this.table);
                    }
                    SelectHelper.refresh(stmt);
                }
                StatementHelper.removeTableExpressionFromQueryStatement((TableExpression)this.table, (SQLQueryObject)stmt);
                stmt.setName(name);
                stmt.setLabel(label);
            } else if (stmt instanceof QueryInsertStatement) {
                String name = stmt.getName();
                String label = stmt.getLabel();
                InsertHelper.clearStatementContents((QueryInsertStatement)stmt);
                stmt.setName(name);
                stmt.setLabel(label);
            } else if (stmt instanceof QueryUpdateStatement) {
                String name = stmt.getName();
                String label = stmt.getLabel();
                UpdateHelper.clearStatementContents((QueryUpdateStatement)stmt);
                stmt.setName(name);
                stmt.setLabel(label);
            } else if (stmt instanceof QueryDeleteStatement) {
                String name = stmt.getName();
                String label = stmt.getLabel();
                DeleteHelper.clearStatementContents((QueryDeleteStatement)stmt);
                stmt.setName(name);
                stmt.setLabel(label);
            }
        }
    }

    class SelectAllColumnsAction
    extends Action {
        Object table;

        public SelectAllColumnsAction() {
            super(Messages._UI_VIEWS_GRAPH_SELECT_ALL_COLUMN);
        }

        public void setTable(Object table) {
            this.table = table;
        }

        public void run() {
            block8: {
                SQLQueryObject currStatement;
                block9: {
                    block7: {
                        currStatement = GraphContextMenuProvider.this.getCurrentStatement();
                        if (!(currStatement instanceof QuerySelectStatement) && !(currStatement instanceof QuerySelect)) break block7;
                        SQLQueryObject selectStatement = currStatement;
                        if (this.table instanceof Table) {
                            Table newTable = (Table)this.table;
                            List tblExprList = StatementHelper.getTablesForStatement((SQLQueryObject)selectStatement);
                            TableExpression tblExpr = TableHelper.getTableExpressionFromTableExprList((String)newTable.getName(), (List)tblExprList);
                            for (Column col : newTable.getColumns()) {
                                ValueExpressionColumn colExpr = SelectHelper.getSelectColumnFromColumnName(selectStatement, col.getName());
                                if (colExpr == null) {
                                    colExpr = TableHelper.getColumnExpressionForColumn((TableExpression)tblExpr, (Column)col);
                                }
                                if (colExpr == null || SelectHelper.isResultColumn(selectStatement, colExpr)) continue;
                                ValueExpressionColumn newColExpr = ExpressionHelper.createColumnExpression(ExpressionHelper.getTableExprForValueExpressionColumn(colExpr), col);
                                SelectHelper.appendResultColumn(selectStatement, (QueryValueExpression)newColExpr, "");
                            }
                        }
                        SelectHelper.refresh(selectStatement);
                        break block8;
                    }
                    if (!(currStatement instanceof QueryInsertStatement)) break block9;
                    QueryInsertStatement insertStatement = (QueryInsertStatement)currStatement;
                    if (!(this.table instanceof Table)) break block8;
                    Table newTable = (Table)this.table;
                    for (Column column : newTable.getColumns()) {
                        ValueExpressionColumn colExpr = InsertHelper.getColumnExpressionForName(insertStatement, column.getName());
                        if (colExpr != null) continue;
                        AdapterFactoryEditingDomain editDomain = GraphContextMenuProvider.this.domainModel.getEditingDomain();
                        InsertHelper.addColumn((EditingDomain)editDomain, insertStatement, column);
                    }
                    break block8;
                }
                if (currStatement instanceof QueryUpdateStatement) {
                    QueryUpdateStatement updateStatement = (QueryUpdateStatement)currStatement;
                    if (this.table instanceof Table) {
                        Table newTable = (Table)this.table;
                        for (Column column : newTable.getColumns()) {
                            ValueExpressionColumn colExpr = UpdateHelper.getColumnExpressionForName(updateStatement, column.getName());
                            if (colExpr != null) continue;
                            UpdateHelper.addColumn(updateStatement, column);
                        }
                    }
                }
            }
        }
    }
}

