/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

public class SearchPattern {
    private SearchPattern() {
    }

    public static boolean match(String pattern, String str, boolean simulateWildcard) {
        if (pattern.length() == 0) {
            if (simulateWildcard) {
                return true;
            }
            return str.length() == 0;
        }
        if (str.length() == 0) {
            if (pattern.charAt(0) != '*') {
                return false;
            }
            return SearchPattern.match(pattern.substring(1), str, simulateWildcard);
        }
        switch (pattern.charAt(0)) {
            case '?': {
                return SearchPattern.match(pattern.substring(1), str.substring(1), simulateWildcard);
            }
            case '*': {
                return SearchPattern.match(pattern.substring(1), str, simulateWildcard) || SearchPattern.match(pattern, str.substring(1), simulateWildcard);
            }
        }
        return str.charAt(0) == pattern.charAt(0) && SearchPattern.match(pattern.substring(1), str.substring(1), simulateWildcard);
    }

    public static boolean match(String pattern, String str, boolean caseSensitive, boolean simulateWildcard) {
        if (pattern == null) {
            return str == null;
        }
        if (str == null) {
            return false;
        }
        if (caseSensitive) {
            return SearchPattern.match(pattern, str, simulateWildcard);
        }
        return SearchPattern.match(pattern.toLowerCase(), str.toLowerCase(), simulateWildcard);
    }

    public static boolean match(String pattern, String str) {
        return SearchPattern.match(pattern, str, true, true);
    }
}

