/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.util.List;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class StringEvaluator
implements IExpressionEvaluator {
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if (expression instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expression;
            return stringLiteral.getLiteralValue();
        }
        if ("java.lang.String".equals(typeQualifiedName) && expression instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)expression;
            Assert.isTrue((infixExpression.getOperator() == InfixExpression.Operator.PLUS ? 1 : 0) != 0);
            List<Expression> extendedOperands = DomGenerics.extendedOperands(infixExpression);
            String[] operands = new String[2 + extendedOperands.size()];
            operands[0] = StringEvaluator.getStringValue(context, infixExpression.getLeftOperand());
            operands[1] = StringEvaluator.getStringValue(context, infixExpression.getRightOperand());
            int i = 0;
            while (i < extendedOperands.size()) {
                Expression operandExpression = extendedOperands.get(i);
                operands[2 + i] = StringEvaluator.getStringValue(context, operandExpression);
                ++i;
            }
            StringBuffer value = new StringBuffer();
            String[] stringArray = operands;
            int n = operands.length;
            int n2 = 0;
            while (n2 < n) {
                String operand = stringArray[n2];
                value.append(operand);
                ++n2;
            }
            return value.toString();
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static String getStringValue(EvaluationContext context, Expression expression) throws Exception {
        Object o = AstEvaluationEngine.evaluate(context, expression);
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return "null";
        }
        return o.toString();
    }
}

