/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AttributeGroup;
import org.eclipse.php.core.ast.nodes.BodyDeclaration;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.visitor.Visitor;

public class FieldsDeclaration
extends BodyDeclaration {
    private Expression fieldsType;
    private final ASTNode.NodeList<SingleFieldDeclaration> fields = new ASTNode.NodeList(FIELDS_PROPERTY);
    public static final SimplePropertyDescriptor MODIFIER_PROPERTY = new SimplePropertyDescriptor(FieldsDeclaration.class, "modifier", Integer.class, false);
    public static final ChildPropertyDescriptor FIELDS_TYPE_PROPERTY = new ChildPropertyDescriptor(FieldsDeclaration.class, "fieldsType", Expression.class, false, true);
    public static final ChildListPropertyDescriptor FIELDS_PROPERTY = new ChildListPropertyDescriptor(FieldsDeclaration.class, "fields", SingleFieldDeclaration.class, true);
    public static final ChildListPropertyDescriptor ATTRIBUTES_PROPERTY = new ChildListPropertyDescriptor(FieldsDeclaration.class, "attributes", AttributeGroup.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS_PHP8;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(3);
        properyList.add(MODIFIER_PROPERTY);
        properyList.add(FIELDS_TYPE_PROPERTY);
        properyList.add(FIELDS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
        properyList = new ArrayList(4);
        properyList.add(MODIFIER_PROPERTY);
        properyList.add(FIELDS_TYPE_PROPERTY);
        properyList.add(FIELDS_PROPERTY);
        properyList.add(ATTRIBUTES_PROPERTY);
        PROPERTY_DESCRIPTORS_PHP8 = Collections.unmodifiableList(properyList);
    }

    @Override
    public final SimplePropertyDescriptor getModifierProperty() {
        return MODIFIER_PROPERTY;
    }

    public FieldsDeclaration(int start, int end, AST ast, int modifier, Expression type, List<SingleFieldDeclaration> variablesAndDefaults, List<AttributeGroup> attributes) {
        super(start, end, ast, modifier);
        if (variablesAndDefaults == null || variablesAndDefaults.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (attributes != null) {
            this.attributes().addAll(attributes);
        }
        if (type != null) {
            this.setFieldsType(type);
        }
        for (SingleFieldDeclaration next : variablesAndDefaults) {
            if (next instanceof SingleFieldDeclaration) {
                this.fields.add(next);
                continue;
            }
            ASTNode[] element = (ASTNode[])next;
            SingleFieldDeclaration field = this.createField(ast, (Variable)element[0], (Expression)element[1]);
            this.fields.add(field);
        }
    }

    public FieldsDeclaration(int start, int end, AST ast, int modifier, Expression type, List<SingleFieldDeclaration> variablesAndDefaults) {
        this(start, end, ast, modifier, type, variablesAndDefaults, null);
    }

    public FieldsDeclaration(int start, int end, AST ast, int modifier, List<SingleFieldDeclaration> variablesAndDefaults) {
        this(start, end, ast, modifier, null, variablesAndDefaults);
    }

    public FieldsDeclaration(AST ast) {
        super(ast);
    }

    private SingleFieldDeclaration createField(AST ast, Variable name, Expression value) {
        int start = name.getStart();
        int end = value == null ? name.getEnd() : value.getEnd();
        SingleFieldDeclaration result = new SingleFieldDeclaration(start, end, ast, name, value);
        return result;
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (AttributeGroup attributeGroup : this.attributes()) {
            attributeGroup.accept(visitor);
        }
        if (this.fieldsType != null) {
            this.fieldsType.accept(visitor);
        }
        for (ASTNode aSTNode : this.fields) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (AttributeGroup attributeGroup : this.attributes()) {
            attributeGroup.traverseTopDown(visitor);
        }
        if (this.fieldsType != null) {
            this.fieldsType.accept(visitor);
        }
        for (ASTNode aSTNode : this.fields) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (AttributeGroup attributeGroup : this.attributes()) {
            attributeGroup.traverseBottomUp(visitor);
        }
        if (this.fieldsType != null) {
            this.fieldsType.accept(visitor);
        }
        for (ASTNode aSTNode : this.fields) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<FieldsDeclaration");
        this.appendInterval(buffer);
        buffer.append(" modifier='").append(this.getModifierString());
        buffer.append("'>\n");
        this.toStringAttributes(buffer, "\t" + tab);
        buffer.append("\t").append(tab).append("<Type>\n");
        if (this.fieldsType != null) {
            this.fieldsType.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Type>\n");
        for (SingleFieldDeclaration node : this.fields) {
            buffer.append(tab).append("\t").append("<VariableName>\n");
            node.getName().toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("</VariableName>\n");
            buffer.append(tab).append("\t").append("<InitialValue>\n");
            Expression expr = node.getValue();
            if (expr != null) {
                expr.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
            buffer.append(tab).append("\t").append("</InitialValue>\n");
        }
        buffer.append(tab).append("</FieldsDeclaration>");
    }

    @Override
    public int getType() {
        return 25;
    }

    public Expression getFieldsType() {
        return this.fieldsType;
    }

    public void setFieldsType(Expression id) {
        if (id != null && !(id instanceof Identifier) && !(id instanceof NamespaceName)) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.fieldsType;
        this.preReplaceChild(oldChild, id, FIELDS_TYPE_PROPERTY);
        this.fieldsType = id;
        this.postReplaceChild(oldChild, id, FIELDS_TYPE_PROPERTY);
    }

    public List<SingleFieldDeclaration> fields() {
        return this.fields;
    }

    public Expression[] getInitialValues() {
        Expression[] result = new Expression[this.fields.size()];
        int i = 0;
        for (SingleFieldDeclaration field : this.fields) {
            result[i++] = field.getValue();
        }
        return result;
    }

    public Variable[] getVariableNames() {
        Variable[] result = new Variable[this.fields.size()];
        int i = 0;
        for (SingleFieldDeclaration field : this.fields) {
            result[i++] = field.getName();
        }
        return result;
    }

    @Override
    final List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == FIELDS_PROPERTY) {
            return this.fields();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == FIELDS_TYPE_PROPERTY) {
            if (get) {
                return this.getFieldsType();
            }
            this.setFieldsType((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression type = ASTNode.copySubtree(target, this.getFieldsType());
        List<SingleFieldDeclaration> fields = ASTNode.copySubtrees(target, this.fields());
        int modifier = this.getModifier();
        return new FieldsDeclaration(this.getStart(), this.getEnd(), target, modifier, type, fields);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        if (PHPVersion.PHP8_0.isGreaterThan(apiLevel)) {
            return PROPERTY_DESCRIPTORS;
        }
        return PROPERTY_DESCRIPTORS_PHP8;
    }

    public final IVariableBinding resolveTypeBinding() {
        return this.ast.getBindingResolver().resolveVariable(this);
    }

    @Override
    protected ChildListPropertyDescriptor getAttributesProperty() {
        return ATTRIBUTES_PROPERTY;
    }
}

