/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.beans.Introspector;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.AccessUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public final class ReflectUtil {
    public static final Class<Object> ROOT_CLASS = Object.class;
    public static final Class<?>[] NO_PARAMETERS = null;
    public static final Object[] NO_ARGUMENTS = null;
    private static final String NAMESPACE_SEPARATOR = ".";
    private static final Method HASH_CODE_METHOD = ReflectUtil.lookupHashCodeMethod();
    private static final Map<Object, Long> ids = new WeakHashMap<Object, Long>();
    private static final Long FAKE_ID = 0L;
    public static boolean REMEMBER_IDS = false;
    public static boolean DUMP_STATICS = false;
    private static long lastID;

    private ReflectUtil() {
    }

    public static <T> void makeAccessible(AccessibleObject accessibleObject) {
        block5: {
            try {
                if (!accessibleObject.isAccessible()) {
                    accessibleObject.setAccessible(true);
                }
            }
            catch (Throwable ex) {
                if (accessibleObject instanceof Field) {
                    AccessUtil.setAccessible((Field)accessibleObject);
                }
                if (accessibleObject instanceof Method) {
                    AccessUtil.setAccessible((Method)accessibleObject);
                }
                if (!(accessibleObject instanceof Constructor)) break block5;
                AccessUtil.setAccessible((Constructor)accessibleObject);
            }
        }
    }

    public static Method getMethod(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            return ReflectUtil.doGetMethod(c, methodName, parameterTypes);
        }
        catch (Exception ex) {
            throw ReflectionException.wrap(ex);
        }
    }

    public static Method getMethodOrNull(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            return ReflectUtil.doGetMethod(c, methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw ReflectionException.wrap(ex);
        }
    }

    private static Method doGetMethod(Class<?> c, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            Method method = c.getDeclaredMethod(methodName, parameterTypes);
            if (method != null) {
                ReflectUtil.makeAccessible(method);
            }
            return method;
        }
        catch (NoSuchMethodException ex) {
            Class<?> superclass = c.getSuperclass();
            if (superclass != null) {
                Method method = ReflectUtil.doGetMethod(superclass, methodName, parameterTypes);
                if (method != null) {
                    ReflectUtil.makeAccessible(method);
                }
                return method;
            }
            throw ex;
        }
    }

    public static Object invokeMethod(Method method, Object target, Object ... arguments) {
        try {
            return method.invoke(target, arguments);
        }
        catch (Exception ex) {
            throw ReflectionException.wrap(ex);
        }
    }

    public static <T> T invokeMethod(String methodName, Object target) {
        if (target instanceof Class) {
            return (T)ReflectUtil.invokeMethod(ReflectUtil.getMethod((Class)target, methodName, new Class[0]), null, new Object[0]);
        }
        return (T)ReflectUtil.invokeMethod(ReflectUtil.getMethod(target.getClass(), methodName, new Class[0]), target, new Object[0]);
    }

    public static Field getField(Class<?> c, String fieldName) {
        try {
            try {
                Field field = c.getDeclaredField(fieldName);
                if (field != null) {
                    ReflectUtil.makeAccessible(field);
                }
                return field;
            }
            catch (NoSuchFieldException ex) {
                Class<?> superclass = c.getSuperclass();
                if (superclass != null) {
                    Field field = ReflectUtil.getField(superclass, fieldName);
                    if (field != null) {
                        ReflectUtil.makeAccessible(field);
                    }
                    return field;
                }
                return null;
            }
        }
        catch (Exception ex) {
            throw ReflectionException.wrap(ex);
        }
    }

    @Deprecated
    public static Field getAccessibleField(Class<?> c, String fieldName) {
        return ReflectUtil.getField(c, fieldName);
    }

    public static void collectFields(Class<?> c, List<Field> fields) {
        if (c == ROOT_CLASS) {
            return;
        }
        ReflectUtil.collectFields(c.getSuperclass(), fields);
        try {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = c.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!field.isSynthetic() && ((field.getModifiers() & 8) == 0 || DUMP_STATICS) && field.getAnnotation(ExcludeFromDump.class) == null) {
                    try {
                        ReflectUtil.makeAccessible(field);
                        fields.add(field);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            throw ReflectionException.wrap(ex);
        }
    }

    public static Object getValue(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (Exception ex) {
            throw ReflectionException.wrap(ex);
        }
    }

    public static <T> T getValue(String fieldName, Object target) {
        if (target instanceof Class) {
            Field field = ReflectUtil.getField((Class)target, fieldName);
            if (field == null) {
                throw new ReflectionException("No such field: " + fieldName);
            }
            return (T)ReflectUtil.getValue(field, null);
        }
        Field field = ReflectUtil.getField(target.getClass(), fieldName);
        if (field == null) {
            throw new ReflectionException("No such field: " + fieldName);
        }
        return (T)ReflectUtil.getValue(field, target);
    }

    public static void setValue(Field field, Object target, Object value) {
        ReflectUtil.setValue(field, target, value, false);
    }

    public static void setValue(Field field, Object target, Object value, boolean force) {
        try {
            if (force && (field.getModifiers() & 0x10) != 0) {
                AccessUtil.setNonFinal(field);
            }
            field.set(target, value);
        }
        catch (Exception ex) {
            throw ReflectionException.wrap(ex);
        }
    }

    public static String dumpThread() {
        StringBuilder builder = new StringBuilder();
        Thread thread = Thread.currentThread();
        builder.append(thread);
        builder.append(StringUtil.NL);
        StackTraceElement[] stackTrace = thread.getStackTrace();
        ReflectUtil.appendStackTrace(builder, stackTrace);
        return builder.toString();
    }

    public static void appendStackTrace(StringBuilder builder, StackTraceElement[] stackTrace) {
        int i = 2;
        while (i < stackTrace.length) {
            StackTraceElement stackTraceElement = stackTrace[i];
            builder.append("\tat " + stackTraceElement);
            builder.append(StringUtil.NL);
            ++i;
        }
    }

    public static void printStackTrace(PrintStream out, StackTraceElement[] stackTrace) {
        int i = 2;
        while (i < stackTrace.length) {
            StackTraceElement stackTraceElement = stackTrace[i];
            out.println("\tat " + stackTraceElement);
            ++i;
        }
    }

    public static void printStackTrace(StackTraceElement[] stackTrace) {
        ReflectUtil.printStackTrace(System.err, stackTrace);
    }

    public static void printStackTrace() {
        ReflectUtil.printStackTrace(Thread.currentThread().getStackTrace());
    }

    public static Integer getHashCode(Object object) {
        try {
            return (Integer)HASH_CODE_METHOD.invoke(object, NO_ARGUMENTS);
        }
        catch (Exception ex) {
            IOUtil.print(ex);
            return 0;
        }
    }

    public static synchronized Long getID(Object object) {
        if (REMEMBER_IDS) {
            Long id = ids.get(object);
            if (id == null) {
                id = ++lastID;
                ids.put(object, id);
            }
            return id;
        }
        return FAKE_ID;
    }

    public static String getPackageName(Class<? extends Object> c) {
        if (c == null) {
            return null;
        }
        return ReflectUtil.getPackageName(c.getName());
    }

    public static String getPackageName(String className) {
        if (className == null) {
            return null;
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(0, lastDot);
        }
        return className;
    }

    public static String getSimpleName(Class<? extends Object> c) {
        if (c == null) {
            return null;
        }
        return c.getSimpleName();
    }

    public static String getSimpleClassName(String name) {
        if (name == null) {
            return null;
        }
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            name = name.substring(lastDot + 1);
        }
        return name.replace('$', '.');
    }

    public static String getSimpleClassName(Object object) {
        if (object == null) {
            return null;
        }
        String name = object.getClass().getName();
        return ReflectUtil.getSimpleClassName(name);
    }

    public static String getLabel(Object object) {
        if (object == null) {
            return null;
        }
        String name = object.getClass().getSimpleName();
        if (name.length() == 0) {
            name = "anonymous";
        }
        if (REMEMBER_IDS) {
            return String.valueOf(name) + "@" + ReflectUtil.getID(object);
        }
        return name;
    }

    public static void dump(Object object) {
        ReflectUtil.dump(object, "");
    }

    public static void dump(Object object, String prefix) {
        ReflectUtil.dump(object, prefix, IOUtil.OUT());
    }

    public static void dump(Object object, String prefix, PrintStream out) {
        out.print(ReflectUtil.toString(object, prefix));
    }

    public static void dump(Object object, Predicate<Setting> consumer) {
        Class<?> c = object.getClass();
        ReflectUtil.dump(object, c, consumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean dump(Object object, Class<?> c, Predicate<Setting> consumer) {
        if (c == ROOT_CLASS) {
            return true;
        }
        if (!ReflectUtil.dump(object, c.getSuperclass(), consumer)) {
            return false;
        }
        try {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = c.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (true) {
                block11: {
                    if (n2 >= n) {
                        return true;
                    }
                    Field field = fieldArray[n2];
                    if (!field.isSynthetic() && ((field.getModifiers() & 8) == 0 || DUMP_STATICS) && field.getAnnotation(ExcludeFromDump.class) == null) {
                        try {
                            ReflectUtil.makeAccessible(field);
                            if (!consumer.test(new Setting(object, field))) {
                                return false;
                            }
                        }
                        catch (Throwable ex) {
                            String getterName = StringUtil.cap(field.getName());
                            Method getter = ReflectUtil.getMethodOrNull(c, getterName, new Class[0]);
                            if (getter == null) {
                                getterName = StringUtil.cap(getterName);
                                Class<?> fieldType = field.getType();
                                getterName = fieldType == Boolean.TYPE || fieldType == Boolean.class ? "is" + getterName : "is" + getterName;
                                getter = ReflectUtil.getMethodOrNull(c, getterName, new Class[0]);
                            }
                            if (getter == null || consumer.test(new Setting(object, field, getter))) break block11;
                            return false;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            throw ReflectionException.wrap(ex);
        }
    }

    public static Pair<Field, Object>[] dumpToArray(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ReflectUtil.collectFields(object.getClass(), fields);
        Pair[] result = new Pair[fields.size()];
        int i = 0;
        for (Field field : fields) {
            Object value = ReflectUtil.getValue(field, object);
            result[i++] = Pair.create(field, value);
        }
        return result;
    }

    public static Object instantiate(Map<Object, Object> properties, String namespace, String classKey, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method[] methods;
        Constructor<?> constructor;
        if (namespace != null) {
            if (namespace.length() == 0) {
                namespace = null;
            } else if (!namespace.endsWith(NAMESPACE_SEPARATOR)) {
                namespace = String.valueOf(namespace) + NAMESPACE_SEPARATOR;
            }
        }
        String className = null;
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            String key = (String)entry.getKey();
            if (namespace != null) {
                if (!key.startsWith(namespace)) continue;
                key = key.substring(namespace.length());
            }
            if (classKey.equals(key)) {
                Object classValue = entry.getValue();
                if (classValue instanceof String) {
                    className = (String)classValue;
                    continue;
                }
                OM.LOG.warn("Value of classKey " + classKey + " is not a String");
                continue;
            }
            values.put(key, entry.getValue());
        }
        if (className == null) {
            throw new IllegalArgumentException("Properties do not contain a valid class name for key " + classKey);
        }
        Class<?> c = classLoader.loadClass(className);
        try {
            constructor = c.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
        Object instance = constructor.newInstance(new Object[0]);
        Method[] methodArray = methods = c.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (ReflectUtil.isSetter(method)) {
                String property = method.getName().substring(3);
                String name = Introspector.decapitalize(property);
                Object value = values.get(name);
                if (value == null) {
                    name = StringUtil.uncap(property);
                    value = values.get(name);
                }
                if (value != null) {
                    Class<?> type = method.getParameterTypes()[0];
                    if (!type.isAssignableFrom(value.getClass())) {
                        if (value instanceof String) {
                            String str = (String)value;
                            value = null;
                            if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
                                value = Boolean.parseBoolean(str);
                            } else if (type.isAssignableFrom(Byte.class) || type.isAssignableFrom(Byte.TYPE)) {
                                value = Byte.parseByte(str);
                            } else if (type.isAssignableFrom(Short.class) || type.isAssignableFrom(Short.TYPE)) {
                                value = Short.parseShort(str);
                            } else if (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE)) {
                                value = Integer.parseInt(str);
                            } else if (type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE)) {
                                value = Long.parseLong(str);
                            } else if (type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE)) {
                                value = Float.valueOf(Float.parseFloat(str));
                            } else if (type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE)) {
                                value = Double.parseDouble(str);
                            }
                        } else {
                            value = null;
                        }
                    }
                    if (value == null) {
                        throw new IllegalArgumentException("Value of property " + name + " can not be assigned to type " + type.getName());
                    }
                    method.invoke(instance, value);
                }
            }
            ++n2;
        }
        return instance;
    }

    public static boolean isSetter(Method method) {
        return method.getParameterTypes().length == 1 && ReflectUtil.isSetterName(method.getName());
    }

    public static boolean isSetterName(String name) {
        return name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3));
    }

    public static String toString(Object object) {
        return ReflectUtil.toString(object, "  ");
    }

    public static String toString(Object object, String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(ReflectUtil.getLabel(object));
        builder.append(StringUtil.NL);
        ReflectUtil.toString(object.getClass(), object, prefix, builder);
        return builder.toString();
    }

    private static void toString(Class<? extends Object> segment, Object object, String prefix, StringBuilder builder) {
        if (segment == ROOT_CLASS || segment == Lifecycle.class) {
            return;
        }
        ReflectUtil.toString(segment.getSuperclass(), object, prefix, builder);
        String segmentPrefix = segment == object.getClass() ? "" : String.valueOf(ReflectUtil.getSimpleName(segment)) + NAMESPACE_SEPARATOR;
        Field[] fieldArray = segment.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!field.isSynthetic() && ((field.getModifiers() & 8) == 0 || DUMP_STATICS) && field.getAnnotation(ExcludeFromDump.class) == null) {
                builder.append(prefix);
                builder.append(segmentPrefix);
                builder.append(field.getName());
                builder.append(" = ");
                ReflectUtil.makeAccessible(field);
                Set value = ReflectUtil.getValue(field, object);
                if (value instanceof Map) {
                    value = ((Map)((Object)value)).entrySet();
                }
                if (value instanceof Collection) {
                    Object[] array;
                    builder.append(StringUtil.NL);
                    Collection collection = value;
                    Object[] objectArray = array = collection.toArray(new Object[collection.size()]);
                    int n3 = array.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object element = objectArray[n4];
                        builder.append("    ");
                        builder.append(element);
                        builder.append(StringUtil.NL);
                        ++n4;
                    }
                } else {
                    builder.append(value);
                    builder.append(StringUtil.NL);
                }
            }
            ++n2;
        }
    }

    private static Method lookupHashCodeMethod() {
        Method method;
        try {
            method = ROOT_CLASS.getMethod("hashCode", NO_PARAMETERS);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
        ReflectUtil.makeAccessible(method);
        return method;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ExcludeFromDump {
    }

    public static enum PrimitiveType {
        BOOLEAN(Boolean.TYPE),
        BYTE(Byte.TYPE),
        CHAR(Character.TYPE),
        SHORT(Short.TYPE),
        INT(Integer.TYPE),
        LONG(Long.TYPE),
        FLOAT(Float.TYPE),
        DOUBLE(Double.TYPE),
        VOID(Void.TYPE),
        NONE(null);

        private static final Map<Class<?>, PrimitiveType> INSTANCES;
        private final Class<?> type;

        static {
            INSTANCES = new HashMap();
            PrimitiveType[] primitiveTypeArray = PrimitiveType.values();
            int n = primitiveTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PrimitiveType primitiveType = primitiveTypeArray[n2];
                if (primitiveType.type != null) {
                    INSTANCES.put(primitiveType.type, primitiveType);
                }
                ++n2;
            }
        }

        private PrimitiveType(Class<?> type) {
            this.type = type;
        }

        public Class<?> type() {
            return this.type;
        }

        public static PrimitiveType forClass(Class<?> clazz) {
            PrimitiveType result = INSTANCES.get(clazz);
            return result == null ? NONE : result;
        }
    }

    public static class ReflectionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReflectionException() {
        }

        public ReflectionException(String message, Exception cause) {
            super(message, cause);
        }

        public ReflectionException(String message) {
            super(message);
        }

        public ReflectionException(Exception cause) {
            super(cause);
        }

        public Exception unwrap() {
            return ReflectionException.unwrap(this);
        }

        public static Exception unwrap(Exception exception) {
            if (exception instanceof ReflectionException) {
                return (Exception)exception.getCause();
            }
            return exception;
        }

        public static ReflectionException wrap(Exception exception) {
            if (exception instanceof ReflectionException) {
                return (ReflectionException)exception;
            }
            return new ReflectionException(exception);
        }
    }

    public static final class Setting {
        private final String name;
        private final Class<?> type;
        private final Object value;

        private Setting(String name, Class<?> type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        private Setting(Object object, Field field) throws IllegalAccessException, IllegalArgumentException {
            this(field.getName(), field.getType(), field.get(object));
        }

        private Setting(Object object, Field field, Method getter) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this(field.getName(), field.getType(), getter.invoke(object, new Object[0]));
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Setting[name=");
            builder.append(this.name);
            builder.append(", type=");
            builder.append(this.type);
            builder.append(", value=");
            builder.append(this.value);
            builder.append("]");
            return builder.toString();
        }
    }
}

