/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.collection.Closeable;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static boolean never() {
        return false;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public static int hashCode(int ... values) {
        int hash = 0;
        int i = 0;
        while (i < values.length) {
            hash += values[i];
            hash = (hash << 7) - hash;
            ++i;
        }
        return hash;
    }

    public static int hashCode(long num) {
        return (int)(num >> 32) ^ (int)(num & 0xFFFFFFFFFFFFFFFFL);
    }

    public static <T> T[] appendtoArray(T[] array, T ... elements) {
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + elements.length);
        System.arraycopy(array, 0, result, 0, array.length);
        System.arraycopy(elements, 0, result, array.length, elements.length);
        return result;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T extends Map<?, ?>> boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T extends Collection<?>> boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static Exception close(Object object) {
        try {
            if (object instanceof Closeable) {
                Closeable closeable = (Closeable)object;
                closeable.close();
            } else if (object instanceof java.io.Closeable) {
                java.io.Closeable closeable = (java.io.Closeable)object;
                closeable.close();
            }
        }
        catch (Exception ex) {
            return ex;
        }
        return null;
    }

    public static <T> T notNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static <T> T tryCast(Object object, Class<T> type) {
        if (type.isInstance(object)) {
            return type.cast(object);
        }
        return null;
    }

    public static <T> void forEachSafe(Iterable<T> iterable, Consumer<T> consumer) {
        if (iterable != null) {
            for (T object : iterable) {
                try {
                    consumer.accept(object);
                }
                catch (Error | RuntimeException ex) {
                    OM.LOG.error(ex);
                }
            }
        }
    }

    public static <T> void forEachSafe(T[] array, Consumer<T> consumer) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                try {
                    consumer.accept(array[i]);
                }
                catch (Error | RuntimeException ex) {
                    OM.LOG.error(ex);
                }
                ++i;
            }
        }
    }
}

