/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.resource.java.QueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;

public abstract class SourceQueryAnnotation
extends SourceAnnotation
implements QueryAnnotation {
    DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    AnnotationElementAdapter<String> nameAdapter;
    String name;
    TextRange nameTextRange;
    final QueryHintsAnnotationContainer hintsContainer = new QueryHintsAnnotationContainer();

    protected SourceQueryAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.name = this.buildName(astAnnotation);
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.hintsContainer.initializeFromContainerAnnotation(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncName(this.buildName(astAnnotation));
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.hintsContainer.synchronize(astAnnotation);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(Annotation astAnnotation) {
        return (String)this.nameAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)this.getNameElementName());
    }

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildStringElementAdapter(this.nameDeclarationAdapter);
    }

    protected abstract String getNameElementName();

    @Override
    public ListIterable<QueryHintAnnotation> getHints() {
        return this.hintsContainer.getNestedAnnotations();
    }

    @Override
    public int getHintsSize() {
        return this.hintsContainer.getNestedAnnotationsSize();
    }

    @Override
    public QueryHintAnnotation hintAt(int index) {
        return (QueryHintAnnotation)this.hintsContainer.getNestedAnnotation(index);
    }

    @Override
    public QueryHintAnnotation addHint(int index) {
        return (QueryHintAnnotation)this.hintsContainer.addNestedAnnotation(index);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.hintsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeHint(int index) {
        this.hintsContainer.removeNestedAnnotation(index);
    }

    protected abstract QueryHintAnnotation buildHint(int var1);

    protected abstract String getHintsElementName();

    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.hintsContainer.isEmpty();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    class QueryHintsAnnotationContainer
    extends SourceModel.AnnotationContainer<QueryHintAnnotation> {
        QueryHintsAnnotationContainer() {
            super((SourceModel)SourceQueryAnnotation.this);
        }

        protected String getNestedAnnotationsListName() {
            return "hints";
        }

        protected String getElementName() {
            return SourceQueryAnnotation.this.getHintsElementName();
        }

        protected String getNestedAnnotationName() {
            return "javax.persistence.QueryHint";
        }

        protected QueryHintAnnotation buildNestedAnnotation(int index) {
            return SourceQueryAnnotation.this.buildHint(index);
        }
    }
}

