/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.piecharts;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.AbstractSeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;

public class CircularSeriesSettings
extends AbstractSeriesSettings
implements ICircularSeriesSettings {
    private Color borderColor = Display.getDefault().getSystemColor(2);
    private int borderWidth = 1;
    private int highlightLineWidth = 2;
    private int borderStyle = 1;
    private ISeries.SeriesType seriesType = ISeries.SeriesType.PIE;
    private boolean redrawOnClick = true;
    private boolean fillEntireSpace = false;
    private ICircularSeriesSettings seriesSettingsHighlight = null;

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public int getBorderStyle() {
        return this.borderStyle;
    }

    @Override
    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    @Override
    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
    }

    @Override
    public void setSeriesType(ISeries.SeriesType type) {
        this.seriesType = type;
    }

    @Override
    public ISeries.SeriesType getSeriesType() {
        return this.seriesType;
    }

    @Override
    public void setRedrawOnClick(boolean redraw) {
        this.redrawOnClick = redraw;
    }

    @Override
    public boolean isRedrawOnClick() {
        return this.redrawOnClick;
    }

    @Override
    public void setHighlightLineWidth(int width) {
        this.highlightLineWidth = width;
    }

    @Override
    public int getHighlightLineWidth() {
        return this.highlightLineWidth;
    }

    @Override
    public void setFillEntireSpace(boolean fillEntireSpace) {
        this.fillEntireSpace = fillEntireSpace;
    }

    @Override
    public boolean isEntireSpaceFilled() {
        return this.fillEntireSpace;
    }

    @Override
    public ISeriesSettings getSeriesSettingsHighlight() {
        if (this.seriesSettingsHighlight == null) {
            try {
                this.seriesSettingsHighlight = (ICircularSeriesSettings)this.clone();
            }
            catch (CloneNotSupportedException e) {
                this.seriesSettingsHighlight = new CircularSeriesSettings();
            }
        }
        return this.seriesSettingsHighlight;
    }

    @Override
    public ISeriesSettings makeDeepCopy() {
        CircularSeriesSettings circularSeriesSettings = new CircularSeriesSettings();
        this.transfer(circularSeriesSettings);
        return circularSeriesSettings;
    }

    @Override
    public boolean transfer(ISeriesSettings seriesSettingsSink) {
        boolean success = false;
        if (seriesSettingsSink instanceof ICircularSeriesSettings) {
            CircularSeriesSettings source = this;
            ICircularSeriesSettings sink = (ICircularSeriesSettings)seriesSettingsSink;
            sink.setDescription(source.getDescription());
            sink.setBorderColor(source.getBorderColor());
            sink.setBorderWidth(source.getBorderWidth());
            sink.setHighlightLineWidth(source.getHighlightLineWidth());
            sink.setBorderStyle(source.getBorderStyle());
            sink.setSeriesType(source.getSeriesType());
            sink.setRedrawOnClick(source.isRedrawOnClick());
            sink.setFillEntireSpace(source.isEntireSpaceFilled());
            success = true;
        }
        return success;
    }

    protected Object clone() throws CloneNotSupportedException {
        CircularSeriesSettings circularSeriesSettings = new CircularSeriesSettings();
        this.transfer(circularSeriesSettings);
        return circularSeriesSettings;
    }
}

