/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ManagerStatus;
import org.mandas.docker.client.messages.swarm.Node;
import org.mandas.docker.client.messages.swarm.NodeDescription;
import org.mandas.docker.client.messages.swarm.NodeSpec;
import org.mandas.docker.client.messages.swarm.NodeStatus;
import org.mandas.docker.client.messages.swarm.Version;

final class ImmutableNode
implements Node {
    private final String id;
    private final Version version;
    private final Date createdAt;
    private final Date updatedAt;
    private final NodeSpec spec;
    private final NodeDescription description;
    private final NodeStatus status;
    @Nullable
    private final ManagerStatus managerStatus;

    private ImmutableNode(String id, Version version, Date createdAt, Date updatedAt, NodeSpec spec, NodeDescription description, NodeStatus status, @Nullable ManagerStatus managerStatus) {
        this.id = id;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.spec = spec;
        this.description = description;
        this.status = status;
        this.managerStatus = managerStatus;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Version")
    public Version version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="CreatedAt")
    public Date createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="UpdatedAt")
    public Date updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="Spec")
    public NodeSpec spec() {
        return this.spec;
    }

    @Override
    @JsonProperty(value="Description")
    public NodeDescription description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="Status")
    public NodeStatus status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="ManagerStatus")
    @Nullable
    public ManagerStatus managerStatus() {
        return this.managerStatus;
    }

    public final ImmutableNode withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableNode(newValue, this.version, this.createdAt, this.updatedAt, this.spec, this.description, this.status, this.managerStatus);
    }

    public final ImmutableNode withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        return new ImmutableNode(this.id, newValue, this.createdAt, this.updatedAt, this.spec, this.description, this.status, this.managerStatus);
    }

    public final ImmutableNode withCreatedAt(Date value) {
        if (this.createdAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableNode(this.id, this.version, newValue, this.updatedAt, this.spec, this.description, this.status, this.managerStatus);
    }

    public final ImmutableNode withUpdatedAt(Date value) {
        if (this.updatedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableNode(this.id, this.version, this.createdAt, newValue, this.spec, this.description, this.status, this.managerStatus);
    }

    public final ImmutableNode withSpec(NodeSpec value) {
        if (this.spec == value) {
            return this;
        }
        NodeSpec newValue = Objects.requireNonNull(value, "spec");
        return new ImmutableNode(this.id, this.version, this.createdAt, this.updatedAt, newValue, this.description, this.status, this.managerStatus);
    }

    public final ImmutableNode withDescription(NodeDescription value) {
        if (this.description == value) {
            return this;
        }
        NodeDescription newValue = Objects.requireNonNull(value, "description");
        return new ImmutableNode(this.id, this.version, this.createdAt, this.updatedAt, this.spec, newValue, this.status, this.managerStatus);
    }

    public final ImmutableNode withStatus(NodeStatus value) {
        if (this.status == value) {
            return this;
        }
        NodeStatus newValue = Objects.requireNonNull(value, "status");
        return new ImmutableNode(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.description, newValue, this.managerStatus);
    }

    public final ImmutableNode withManagerStatus(@Nullable ManagerStatus value) {
        if (this.managerStatus == value) {
            return this;
        }
        return new ImmutableNode(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.description, this.status, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNode && this.equalTo((ImmutableNode)another);
    }

    private boolean equalTo(ImmutableNode another) {
        return this.id.equals(another.id) && this.version.equals(another.version) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.spec.equals(another.spec) && this.description.equals(another.description) && this.status.equals(another.status) && Objects.equals(this.managerStatus, another.managerStatus);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + this.spec.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.managerStatus);
        return h;
    }

    public String toString() {
        return "Node{id=" + this.id + ", version=" + this.version + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", spec=" + this.spec + ", description=" + this.description + ", status=" + this.status + ", managerStatus=" + this.managerStatus + "}";
    }

    public static ImmutableNode copyOf(Node instance) {
        if (instance instanceof ImmutableNode) {
            return (ImmutableNode)instance;
        }
        return ImmutableNode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_SPEC = 16L;
        private static final long INIT_BIT_DESCRIPTION = 32L;
        private static final long INIT_BIT_STATUS = 64L;
        private long initBits = 127L;
        private String id;
        private Version version;
        private Date createdAt;
        private Date updatedAt;
        private NodeSpec spec;
        private NodeDescription description;
        private NodeStatus status;
        private ManagerStatus managerStatus;

        private Builder() {
        }

        public final Builder from(Node instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.version(instance.version());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            this.spec(instance.spec());
            this.description(instance.description());
            this.status(instance.status());
            ManagerStatus managerStatusValue = instance.managerStatus();
            if (managerStatusValue != null) {
                this.managerStatus(managerStatusValue);
            }
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Version")
        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="CreatedAt")
        public final Builder createdAt(Date createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="UpdatedAt")
        public final Builder updatedAt(Date updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Spec")
        public final Builder spec(NodeSpec spec) {
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="Description")
        public final Builder description(NodeDescription description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Status")
        public final Builder status(NodeStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="ManagerStatus")
        public final Builder managerStatus(@Nullable ManagerStatus managerStatus) {
            this.managerStatus = managerStatus;
            return this;
        }

        public ImmutableNode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNode(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.description, this.status, this.managerStatus);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("spec");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build Node, some of required attributes are not set " + attributes;
        }
    }

    static final class Criteria
    implements Node.Criteria {
        @Nullable
        private final String nodeId;
        @Nullable
        private final String label;
        @Nullable
        private final String membership;
        @Nullable
        private final String nodeName;
        @Nullable
        private final String nodeRole;

        private Criteria(@Nullable String nodeId, @Nullable String label, @Nullable String membership, @Nullable String nodeName, @Nullable String nodeRole) {
            this.nodeId = nodeId;
            this.label = label;
            this.membership = membership;
            this.nodeName = nodeName;
            this.nodeRole = nodeRole;
        }

        @Override
        @JsonProperty(value="nodeId")
        @Nullable
        public String nodeId() {
            return this.nodeId;
        }

        @Override
        @JsonProperty(value="label")
        @Nullable
        public String label() {
            return this.label;
        }

        @Override
        @JsonProperty(value="membership")
        @Nullable
        public String membership() {
            return this.membership;
        }

        @Override
        @JsonProperty(value="nodeName")
        @Nullable
        public String nodeName() {
            return this.nodeName;
        }

        @Override
        @JsonProperty(value="nodeRole")
        @Nullable
        public String nodeRole() {
            return this.nodeRole;
        }

        public final Criteria withNodeId(@Nullable String value) {
            if (Objects.equals(this.nodeId, value)) {
                return this;
            }
            return new Criteria(value, this.label, this.membership, this.nodeName, this.nodeRole);
        }

        public final Criteria withLabel(@Nullable String value) {
            if (Objects.equals(this.label, value)) {
                return this;
            }
            return new Criteria(this.nodeId, value, this.membership, this.nodeName, this.nodeRole);
        }

        public final Criteria withMembership(@Nullable String value) {
            if (Objects.equals(this.membership, value)) {
                return this;
            }
            return new Criteria(this.nodeId, this.label, value, this.nodeName, this.nodeRole);
        }

        public final Criteria withNodeName(@Nullable String value) {
            if (Objects.equals(this.nodeName, value)) {
                return this;
            }
            return new Criteria(this.nodeId, this.label, this.membership, value, this.nodeRole);
        }

        public final Criteria withNodeRole(@Nullable String value) {
            if (Objects.equals(this.nodeRole, value)) {
                return this;
            }
            return new Criteria(this.nodeId, this.label, this.membership, this.nodeName, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Criteria && this.equalTo((Criteria)another);
        }

        private boolean equalTo(Criteria another) {
            return Objects.equals(this.nodeId, another.nodeId) && Objects.equals(this.label, another.label) && Objects.equals(this.membership, another.membership) && Objects.equals(this.nodeName, another.nodeName) && Objects.equals(this.nodeRole, another.nodeRole);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.nodeId);
            h += (h << 5) + Objects.hashCode(this.label);
            h += (h << 5) + Objects.hashCode(this.membership);
            h += (h << 5) + Objects.hashCode(this.nodeName);
            h += (h << 5) + Objects.hashCode(this.nodeRole);
            return h;
        }

        public String toString() {
            return "Criteria{nodeId=" + this.nodeId + ", label=" + this.label + ", membership=" + this.membership + ", nodeName=" + this.nodeName + ", nodeRole=" + this.nodeRole + "}";
        }

        public static Criteria copyOf(Node.Criteria instance) {
            if (instance instanceof Criteria) {
                return (Criteria)instance;
            }
            return Criteria.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements Node.Criteria.Builder {
            private String nodeId;
            private String label;
            private String membership;
            private String nodeName;
            private String nodeRole;

            private Builder() {
            }

            public final Builder from(Node.Criteria instance) {
                String nodeRoleValue;
                String nodeNameValue;
                String membershipValue;
                String labelValue;
                Objects.requireNonNull(instance, "instance");
                String nodeIdValue = instance.nodeId();
                if (nodeIdValue != null) {
                    this.nodeId(nodeIdValue);
                }
                if ((labelValue = instance.label()) != null) {
                    this.label(labelValue);
                }
                if ((membershipValue = instance.membership()) != null) {
                    this.membership(membershipValue);
                }
                if ((nodeNameValue = instance.nodeName()) != null) {
                    this.nodeName(nodeNameValue);
                }
                if ((nodeRoleValue = instance.nodeRole()) != null) {
                    this.nodeRole(nodeRoleValue);
                }
                return this;
            }

            @Override
            @JsonProperty(value="nodeId")
            public final Builder nodeId(@Nullable String nodeId) {
                this.nodeId = nodeId;
                return this;
            }

            @Override
            @JsonProperty(value="label")
            public final Builder label(@Nullable String label) {
                this.label = label;
                return this;
            }

            @Override
            @JsonProperty(value="membership")
            public final Builder membership(@Nullable String membership) {
                this.membership = membership;
                return this;
            }

            @Override
            @JsonProperty(value="nodeName")
            public final Builder nodeName(@Nullable String nodeName) {
                this.nodeName = nodeName;
                return this;
            }

            @Override
            @JsonProperty(value="nodeRole")
            public final Builder nodeRole(@Nullable String nodeRole) {
                this.nodeRole = nodeRole;
                return this;
            }

            @Override
            public Criteria build() {
                return new Criteria(this.nodeId, this.label, this.membership, this.nodeName, this.nodeRole);
            }
        }
    }
}

