/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.file;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.ui.controls.BaseDialogSelectionControl;
import org.eclipse.tcf.te.ui.controls.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.DirectoryNameValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;

public class DirectorySelectionControl
extends BaseDialogSelectionControl
implements IDataExchangeNode {
    private String dialogMessage = "";

    public DirectorySelectionControl(IDialogPage parentPage) {
        super(parentPage);
        this.setDialogTitle(Messages.DirectorySelectionControl_title);
        this.setGroupLabel(Messages.DirectorySelectionControl_group_label);
        this.setEditFieldLabel(Messages.DirectorySelectionControl_editfield_label);
    }

    public void setDialogMessage(String message) {
        this.dialogMessage = message == null ? "" : message;
    }

    public String getDialogMessage() {
        return this.dialogMessage;
    }

    @Override
    protected Dialog doCreateDialogControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
        return dialog;
    }

    @Override
    protected void configureDialogControl(Dialog dialog) {
        super.configureDialogControl(dialog);
        if (dialog instanceof DirectoryDialog) {
            DirectoryDialog directoryDialog = (DirectoryDialog)dialog;
            String selectedDirectory = this.doGetSelectedDirectory();
            if (selectedDirectory != null && selectedDirectory.trim().length() > 0) {
                directoryDialog.setFilterPath(selectedDirectory);
            } else if (Platform.getBundle((String)"org.eclipse.core.resources") != null && Platform.getBundle((String)"org.eclipse.core.resources").getState() == 32) {
                directoryDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
            }
            directoryDialog.setMessage(this.getDialogMessage());
        }
    }

    protected String doGetSelectedDirectory() {
        return this.getEditFieldControlText();
    }

    @Override
    protected Validator doCreateEditFieldValidator() {
        return new DirectoryNameValidator(15);
    }

    @Override
    public void setEditFieldValidator(Validator editFieldValidator) {
        Assert.isTrue((boolean)(editFieldValidator instanceof DirectoryNameValidator));
        if (editFieldValidator instanceof DirectoryNameValidator) {
            super.setEditFieldValidator(editFieldValidator);
        }
    }

    @Override
    protected String doOpenDialogControl(Dialog dialog) {
        Assert.isNotNull((Object)dialog);
        if (dialog instanceof DirectoryDialog) {
            DirectoryDialog directoryDialog = (DirectoryDialog)dialog;
            return directoryDialog.open();
        }
        return null;
    }

    protected String getPropertiesKey() {
        return "Directory";
    }

    public void setupData(IPropertiesContainer data) {
        String dir = data.getStringProperty(this.getPropertiesKey());
        Path path = dir != null ? new Path(dir) : null;
        this.setEditFieldControlText(path != null ? path.toOSString() : "");
    }

    public void extractData(IPropertiesContainer data) {
        String dir = this.doGetSelectedDirectory();
        Path path = dir.trim().length() > 0 ? new Path(dir) : null;
        data.setProperty(this.getPropertiesKey(), (Object)(path != null ? path.toPortableString() : null));
    }

    public boolean checkDataChanged(IPropertiesContainer data) {
        PropertiesContainer newData = new PropertiesContainer();
        this.extractData((IPropertiesContainer)newData);
        String newValue = newData.getStringProperty(this.getPropertiesKey());
        String oldValue = data.getStringProperty(this.getPropertiesKey());
        if (oldValue == null) {
            return newValue != null;
        }
        return newValue == null || !oldValue.equals(newValue);
    }
}

