/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.button;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.handler.ButtonHandler;
import org.eclipse.reddeer.core.matcher.WithStyleMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.condition.ControlIsEnabled;
import org.eclipse.reddeer.swt.widgets.AbstractControl;
import org.eclipse.swt.widgets.Button;
import org.hamcrest.Matcher;

public abstract class AbstractButton
extends AbstractControl<Button>
implements org.eclipse.reddeer.swt.api.Button {
    private static final Logger log = Logger.getLogger(AbstractButton.class);

    protected AbstractButton(Button widget) {
        super(widget);
    }

    protected AbstractButton(ReferencedComposite refComposite, int index, int style, Matcher<?> ... matchers) {
        super(Button.class, refComposite, index, AbstractButton.createMatchers(style, matchers));
    }

    public static Matcher<?>[] createMatchers(int style, Matcher<?> ... matchers) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new WithStyleMatcher(style));
        list.addAll(Arrays.asList(matchers));
        return list.toArray(new Matcher[list.size()]);
    }

    @Override
    public void click() {
        log.info("Click button " + this.getDescriptiveText());
        new WaitUntil((WaitCondition)new ControlIsEnabled(this));
        ButtonHandler.getInstance().click((Button)this.swtWidget);
    }

    @Override
    public String getText() {
        return ButtonHandler.getInstance().getText((Button)this.swtWidget);
    }

    protected String getDescriptiveText() {
        return this.getText() != null ? this.getText() : (this.getToolTipText() != null ? this.getToolTipText() : "with no text or tooltip");
    }

    @Override
    public void setFocus() {
        ButtonHandler.getInstance().setFocus((Button)this.swtWidget);
    }
}

