/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.mylyn.internal.tasks.ui.editors.CheckboxMultiSelectAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;

public class BugzillaKeywordAttributeEditor
extends CheckboxMultiSelectAttributeEditor {
    public BugzillaKeywordAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
    }

    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        String selectedKeywords = this.getAttributeMapper().getValue(this.getTaskAttribute());
        StringTokenizer st = new StringTokenizer(selectedKeywords, ",", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            values.add(s);
        }
        return values;
    }

    public void setValues(List<String> newValues) {
        StringBuilder valueString = new StringBuilder();
        Collections.sort(newValues);
        int i = 0;
        while (i < newValues.size()) {
            valueString.append(newValues.get(i));
            if (i != newValues.size() - 1) {
                valueString.append(", ");
            }
            ++i;
        }
        this.getAttributeMapper().setValue(this.getTaskAttribute(), valueString.toString());
        this.attributeChanged();
    }
}

