/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.index.Q7ProjectIndexer;

public class ProjectIndexerManager {
    private static Q7ProjectIndexer indexer = new Q7ProjectIndexer();

    public static void indexProject(IProject res) {
        IQ7Project prj = RcpttCore.create(res);
        if (prj.exists()) {
            indexer.indexProject(prj);
        }
    }

    public static void removeProject(IPath projectPath) {
        indexer.removeProject(projectPath);
    }

    public static void indexProject(IQ7Project q7Project) {
        indexer.indexProject(q7Project);
    }

    public static boolean isIndexerEnabled(IProject project) {
        return true;
    }

    public static void indexNamedElement(IQ7NamedElement element) {
        indexer.indexNamedElement(element);
    }

    public static void removeNamedElement(IQ7Project project, String path) {
        indexer.removeNamedElement(project, path);
    }

    public static void startIndexing() {
        boolean wantRefresh = indexer.wantRefreshOnStart();
        if (wantRefresh) {
            IQ7Project[] projects;
            try {
                projects = RcpttCore.create(ResourcesPlugin.getWorkspace().getRoot()).getProjects();
            }
            catch (Exception e) {
                RcpttPlugin.log(e);
                return;
            }
            int i = 0;
            while (i < projects.length) {
                IQ7Project project = projects[i];
                indexer.indexProject(project);
                ++i;
            }
        }
    }

    public static void indexNamedElements(Collection<IQ7NamedElement> toIndex) {
        indexer.indexNamedElements(toIndex);
    }
}

