/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import org.eclipse.core.internal.refresh.MonitorJob;
import org.eclipse.core.internal.refresh.MonitorManager;
import org.eclipse.core.internal.refresh.RefreshJob;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class RefreshManager
implements IRefreshResult,
IManager,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String DEBUG_PREFIX = "Auto-refresh: ";
    volatile MonitorManager monitors;
    private volatile RefreshJob refreshJob;
    private final Workspace workspace;

    public RefreshManager(Workspace workspace) {
        this.workspace = workspace;
    }

    protected void manageAutoRefresh(boolean enabled, IProgressMonitor progressMonitor) {
        if (this.refreshJob == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1);
        if (enabled) {
            this.monitors.start((IProgressMonitor)subMonitor.split(1));
        } else {
            this.refreshJob.cancel();
            this.monitors.stop();
        }
    }

    Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public void monitorFailed(IRefreshMonitor monitor, IResource resource) {
        if (this.monitors != null) {
            this.monitors.monitorFailed(monitor, resource);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String property = event.getKey();
        if ("refresh.enabled".equals(property)) {
            boolean autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.enabled", false, null);
            String jobName = autoRefresh ? Messages.refresh_installMonitorsOnWorkspace : Messages.refresh_uninstallMonitorsOnWorkspace;
            MonitorJob.createSystem(jobName, this.getWorkspace().getRoot(), monitor -> this.manageAutoRefresh(autoRefresh, monitor)).schedule();
        }
    }

    @Override
    public void refresh(IResource resource) {
        if (this.refreshJob != null) {
            this.refreshJob.refresh(resource);
        }
    }

    @Override
    public void shutdown(IProgressMonitor monitor) {
        if (this.refreshJob == null) {
            return;
        }
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (this.monitors != null) {
            this.monitors.stop();
            this.monitors = null;
        }
        if (this.refreshJob != null) {
            this.refreshJob.stop();
            this.refreshJob = null;
        }
    }

    @Override
    public void startup(IProgressMonitor monitor) {
        this.refreshJob = new RefreshJob(this.workspace);
        this.monitors = new MonitorManager(this.workspace, this);
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        boolean autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.enabled", false, null);
        if (autoRefresh) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            this.manageAutoRefresh(autoRefresh, (IProgressMonitor)subMonitor.split(1));
        }
    }
}

