/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Function;

public class FieldAccess<T, R>
implements Function<T, R> {
    private final Field field;
    private Class<R> fieldType;

    public FieldAccess(Class<T> originalClass, Class<R> fieldType, String fieldName) throws NoSuchFieldException {
        this.fieldType = fieldType;
        Class<T> class_ = originalClass;
        Field result = null;
        while (true) {
            try {
                Field field = class_.getDeclaredField(fieldName);
                if (!FieldAccess.isAssignable(fieldType, field.getType())) {
                    throw new NoSuchFieldException("");
                }
                field.setAccessible(true);
                result = field;
            }
            catch (NoSuchFieldException e) {
                if ((class_ = class_.getSuperclass()) != null) continue;
                throw new NoSuchFieldException("Can't find field of type" + fieldType.getName() + " in " + originalClass.getName());
            }
            break;
        }
        this.field = Objects.requireNonNull(result);
    }

    @Override
    public R apply(T t) {
        try {
            return this.fieldType.cast(this.field.get(t));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean isAssignable(Class<?> to, Class<?> from) {
        if (to.isAssignableFrom(from)) {
            return true;
        }
        try {
            Class primitive = (Class)to.getField("TYPE").get(to);
            return primitive.isAssignableFrom(from);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            return false;
        }
    }
}

