/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.doc;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.eclipse.rcptt.ecl.doc.IEclDocProvider;

public class EclDocWriter {
    private Writer out;
    private boolean openNodeClosed = true;
    private static final String NEWLINE = "\n";
    private static final String INDENT = "  ";
    private int level = 0;
    private Stack<String> openNodes = new Stack();

    public static String writeToString(IEclDocProvider provider, String errorMessage) {
        try {
            StringWriter buffer = new StringWriter();
            EclDocWriter w = new EclDocWriter(buffer);
            provider.writeEclDoc(w);
            w.finish();
            return buffer.toString();
        }
        catch (IOException e) {
            return errorMessage;
        }
    }

    public EclDocWriter(Writer out) {
        this.out = out;
    }

    public void finish() throws IOException {
        while (!this.openNodes.isEmpty()) {
            this.close();
        }
        this.out.flush();
        this.out.close();
    }

    public void dl() throws IOException {
        this.open("dl");
    }

    public void dt(String innerHtml) throws IOException {
        this.open("dt");
        this.text(innerHtml);
        this.close();
    }

    public void b(String innerHtml) throws IOException {
        this.open("b");
        this.text(innerHtml);
        this.close();
    }

    public void dd() throws IOException {
        this.open("dd");
    }

    public void dd(String innerHtml) throws IOException {
        this.dd();
        this.text(innerHtml);
        this.close();
    }

    public void pre(String innerHtml) throws IOException {
        this.open("pre");
        this.closeOpenTag();
        this.out.append(innerHtml);
        this.close();
    }

    public void anchor(String anchor) throws IOException {
        this.open("a").attr("id", anchor).text("").close();
    }

    public EclDocWriter text(String text) throws IOException {
        this.closeOpenTag();
        String[] stringArray = text.split("(\r)?\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.writeIndent();
            this.out.append(line).append(NEWLINE);
            ++n2;
        }
        return this;
    }

    public void raw(String text) throws IOException {
        this.out.append(text);
    }

    public void raw(Integer number) throws IOException {
        this.raw(number.toString());
    }

    public void tag(String node, String text) throws IOException {
        this.closeOpenTag();
        this.writeIndent();
        this.out.append(String.format("<%s>", node)).append(text).append(String.format("</%s>", node)).append(NEWLINE);
    }

    public void close() throws IOException {
        --this.level;
        if (!this.openNodeClosed) {
            this.out.append(" />").append(NEWLINE);
            this.openNodeClosed = true;
            this.openNodes.pop();
        } else {
            this.writeIndent();
            this.out.append(String.format("</%s>", this.openNodes.pop())).append(NEWLINE);
        }
    }

    private void closeOpenTag() throws IOException {
        if (this.openNodeClosed) {
            return;
        }
        this.out.append(">").append(NEWLINE);
        this.openNodeClosed = true;
    }

    public EclDocWriter open(String node) throws IOException {
        if (!this.openNodeClosed) {
            this.out.append(">").append(NEWLINE);
        }
        this.writeIndent();
        this.out.append(String.format("<%s", node));
        this.openNodes.push(node);
        this.openNodeClosed = false;
        ++this.level;
        return this;
    }

    public EclDocWriter attr(String name, String value) throws IOException {
        this.out.append(String.format(" %s=\"%s\"", name, value));
        return this;
    }

    private void writeIndent() throws IOException {
        int i = 0;
        while (i < this.level) {
            this.out.append(INDENT);
            ++i;
        }
    }
}

