/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.deltas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7ElementChangedEvent;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.ModelInfo;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Openable;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7FolderInfo;
import org.eclipse.rcptt.internal.core.model.Q7Model;
import org.eclipse.rcptt.internal.core.model.Q7NamedElement;
import org.eclipse.rcptt.internal.core.model.Q7Project;
import org.eclipse.rcptt.internal.core.model.Q7ProjectInfo;
import org.eclipse.rcptt.internal.core.model.deltas.DeltaProcessingState;
import org.eclipse.rcptt.internal.core.model.deltas.ModelUpdater;
import org.eclipse.rcptt.internal.core.model.deltas.Q7ElementDelta;
import org.eclipse.rcptt.internal.core.model.index.IndexManager;
import org.eclipse.rcptt.internal.core.model.index.ProjectIndexerManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DeltaProcessor {
    public static boolean DEBUG = false;
    public static boolean VERBOSE = false;
    public static final int DEFAULT_CHANGE_EVENT = 0;
    private static final ILog LOG = Platform.getLog((Bundle)FrameworkUtil.getBundle(DeltaProcessor.class));
    private final DeltaProcessingState state;
    ModelManager manager;
    private Q7ElementDelta currentDelta;
    private Openable currentElement;
    public ArrayList<IQ7ElementDelta> modelDeltas = new ArrayList();
    public HashMap reconcileDeltas = new HashMap();
    private boolean isFiring = true;
    private final ModelUpdater modelUpdater = new ModelUpdater();
    private final HashSet<IQ7Project> projectCachesToReset = new HashSet();
    private HashSet<IQ7Element> refreshedElements;
    private final HashSet<IQ7Project> rootsToRefresh = new HashSet();
    private final ArrayList<Runnable> postActions = new ArrayList();
    public int overridenEventType = -1;

    public static long getTimeStamp(IFile file) {
        long lmodif = 0L;
        lmodif = file.getModificationStamp();
        return lmodif;
    }

    public DeltaProcessor(DeltaProcessingState state, ModelManager manager) {
        this.state = state;
        this.manager = manager;
    }

    private void addDependentProjects(IQ7Project project, HashMap projectDependencies, HashSet result) {
        IQ7Project[] dependents = (IQ7Project[])projectDependencies.get(project);
        if (dependents == null) {
            return;
        }
        int i = 0;
        int length = dependents.length;
        while (i < length) {
            IQ7Project dependent = dependents[i];
            if (!result.contains(dependent)) {
                result.add(dependent);
                this.addDependentProjects(dependent, projectDependencies, result);
            }
            ++i;
        }
    }

    public void addForRefresh(IQ7Element element) {
        if (this.refreshedElements == null) {
            this.refreshedElements = new HashSet();
        }
        this.refreshedElements.add(element);
    }

    private void addToParentInfo(Openable child) throws InterruptedException {
        Openable parent = (Openable)child.getParent();
        if (parent == null) {
            return;
        }
        parent.accessInfo(info -> {
            OpenableElementInfo openable2 = (OpenableElementInfo)info;
            if (openable2.isStructureKnown()) {
                info.addChild(child);
            }
            return null;
        });
    }

    private void addToRootsToRefreshWithDependents(IQ7Project q7Project) {
        this.rootsToRefresh.add(q7Project);
        this.addDependentProjects(q7Project, this.state.projectDependencies, this.rootsToRefresh);
    }

    private void checkProjectsBeingAddedOrRemoved(IResourceDelta delta) throws InterruptedException {
        IResource resource = delta.getResource();
        IResourceDelta[] children = null;
        switch (resource.getType()) {
            case 8: {
                this.state.getOldProjectNames();
                children = delta.getAffectedChildren();
                break;
            }
            case 4: {
                IProject project = (IProject)resource;
                Q7Project q7Project = (Q7Project)RcpttCore.create(project);
                switch (delta.getKind()) {
                    case 1: {
                        this.addToRootsToRefreshWithDependents(q7Project);
                        if (!RcpttCore.hasRcpttNature(project)) break;
                        this.addToParentInfo(q7Project);
                        break;
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x4000) != 0) {
                            this.addToRootsToRefreshWithDependents(q7Project);
                            if (project.isOpen()) {
                                if (!RcpttCore.hasRcpttNature(project)) break;
                                this.addToParentInfo(q7Project);
                                break;
                            }
                            try {
                                q7Project.close();
                            }
                            catch (ModelException modelException) {
                                // empty catch block
                            }
                            this.removeFromParentInfo(q7Project);
                            break;
                        }
                        if ((delta.getFlags() & 0x80000) != 0) {
                            boolean isQ7Project = RcpttCore.hasRcpttNature(project);
                            this.addToRootsToRefreshWithDependents(q7Project);
                            if (isQ7Project) {
                                this.addToParentInfo(q7Project);
                                break;
                            }
                            try {
                                q7Project.close();
                            }
                            catch (ModelException modelException) {
                                // empty catch block
                            }
                            this.removeFromParentInfo(q7Project);
                            break;
                        }
                        if (!RcpttCore.hasRcpttNature(project)) break;
                        this.addToParentInfo(q7Project);
                        children = delta.getAffectedChildren();
                        break;
                    }
                }
                this.addForRefresh(q7Project);
            }
        }
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.checkProjectsBeingAddedOrRemoved(children[i]);
                ++i;
            }
        }
    }

    private void close(Openable element) {
        try {
            element.close();
        }
        catch (ModelException e) {
            LOG.log(e.getStatus());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            OperationCanceledException result = new OperationCanceledException();
            result.initCause((Throwable)e);
            throw result;
        }
    }

    private void contentChanged(Openable element) {
        boolean isPrimaryWorkingCopy = false;
        if (element.getElementType().equals((Object)IQ7Element.HandleType.Context) || element.getElementType().equals((Object)IQ7Element.HandleType.Verification) || element.getElementType().equals((Object)IQ7Element.HandleType.TestCase) || element.getElementType().equals((Object)IQ7Element.HandleType.TestSuite)) {
            Q7NamedElement cu = (Q7NamedElement)element;
            isPrimaryWorkingCopy = cu.isWorkingCopy();
        }
        if (element.getElementType().equals((Object)IQ7Element.HandleType.ProjectMetadata)) {
            this.currentDelta().changed(element.getQ7Project(), 524288);
        }
        if (isPrimaryWorkingCopy) {
            this.currentDelta().changed(element, 262144);
        } else {
            this.currentDelta().changed(element, 1);
        }
    }

    private Openable createElement(IResource resource, IQ7Element.HandleType elementType, Q7Project rootInfo) throws InterruptedException {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getFullPath();
        IQ7Element element = null;
        switch (elementType) {
            case Project: {
                if (!(resource instanceof IProject)) break;
                this.popUntilPrefixOf(path);
                if (this.currentElement != null && this.currentElement.getElementType().equals((Object)IQ7Element.HandleType.Project) && ((IQ7Project)((Object)this.currentElement)).getProject().equals((Object)resource)) {
                    return this.currentElement;
                }
                if (rootInfo != null && rootInfo.getProject().equals((Object)resource)) {
                    element = rootInfo;
                    break;
                }
                IProject proj = (IProject)resource;
                if (RcpttCore.hasRcpttNature(proj)) {
                    element = RcpttCore.create(proj);
                    break;
                }
                element = this.state.findProject(proj.getName());
                break;
            }
            case Folder: {
                if (rootInfo != null) {
                    if (!rootInfo.contains(resource)) break;
                    IPath pkgPath = path.removeFirstSegments(rootInfo.getPath().segmentCount());
                    element = rootInfo.getFolder(pkgPath);
                    break;
                }
                this.popUntilPrefixOf(path);
                if (this.currentElement == null) {
                    element = RcpttCore.create(resource);
                    break;
                }
                rootInfo = (Q7Project)this.currentElement.getQ7Project();
                if (!((Q7Project)rootInfo.getProject()).contains(resource)) break;
                IPath pkgPath = path.removeFirstSegments(rootInfo.getPath().segmentCount());
                element = rootInfo.getFolder(pkgPath);
                break;
            }
            case TestCase: 
            case Context: 
            case TestSuite: 
            case ProjectMetadata: 
            case Verification: {
                this.popUntilPrefixOf(path);
                if (this.currentElement == null) {
                    element = rootInfo == null ? RcpttCore.create(resource) : ModelManager.create(resource, (IQ7Project)rootInfo);
                    break;
                }
                IQ7Folder pkgFragment = null;
                switch (this.currentElement.getElementType()) {
                    case Folder: {
                        Openable pkg = this.currentElement;
                        if (!pkg.getPath().equals((Object)path.removeLastSegments(1))) break;
                        pkgFragment = (IQ7Folder)((Object)pkg);
                        break;
                    }
                    case TestCase: 
                    case Context: 
                    case TestSuite: 
                    case ProjectMetadata: 
                    case Verification: {
                        pkgFragment = (IQ7Folder)this.currentElement.getParent();
                    }
                }
                if (pkgFragment == null) {
                    element = rootInfo == null ? RcpttCore.create(resource) : ModelManager.create(resource, (IQ7Project)rootInfo);
                    break;
                }
                if (!elementType.equals((Object)IQ7Element.HandleType.Context) && !elementType.equals((Object)IQ7Element.HandleType.Verification) && !elementType.equals((Object)IQ7Element.HandleType.TestCase) && !elementType.equals((Object)IQ7Element.HandleType.TestSuite) && !elementType.equals((Object)IQ7Element.HandleType.TestSuite)) break;
                String fileName = path.lastSegment();
                element = pkgFragment.getNamedElement(fileName);
            }
        }
        if (element == null) {
            return null;
        }
        this.currentElement = (Openable)element;
        return this.currentElement;
    }

    private Q7ElementDelta currentDelta() {
        if (this.currentDelta == null) {
            this.currentDelta = new Q7ElementDelta(this.manager.getModel());
        }
        return this.currentDelta;
    }

    private void deleting(IProject project) throws InterruptedException {
        try {
            this.manager.getIndexManager().discardJobs(project.getName());
            Q7Project q7Project = (Q7Project)RcpttCore.create(project);
            q7Project.close();
            this.state.getOldProjectNames();
            this.removeFromParentInfo(q7Project);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    private void elementAdded(Openable element, IResourceDelta delta) throws InterruptedException {
        IQ7Element.HandleType elementType = element.getElementType();
        if (elementType.equals((Object)IQ7Element.HandleType.Project)) {
            if (delta != null && RcpttCore.hasRcpttNature((IProject)delta.getResource())) {
                this.addToParentInfo(element);
                if ((delta.getFlags() & 0x1000) != 0) {
                    Openable movedFromElement = (Openable)((Object)element.getModel().getProject(delta.getMovedFromPath().lastSegment()));
                    this.currentDelta().movedTo(element, movedFromElement);
                } else {
                    this.close(element);
                    this.currentDelta().added(element);
                }
                IQ7Project project = (IQ7Project)((Object)element);
                this.rootsToRefresh.add(project);
                this.projectCachesToReset.add(project);
            }
        } else {
            if (delta == null || (delta.getFlags() & 0x1000) == 0) {
                if (this.isWorkingCopy(element, elementType)) {
                    this.currentDelta().changed(element, 262144);
                } else {
                    this.addToParentInfo(element);
                    this.close(element);
                    this.currentDelta().added(element);
                }
            } else {
                this.addToParentInfo(element);
                this.close(element);
                IPath movedFromPath = delta.getMovedFromPath();
                IResource res = delta.getResource();
                Object movedFromRes = res instanceof IFile ? res.getWorkspace().getRoot().getFile(movedFromPath) : res.getWorkspace().getRoot().getFolder(movedFromPath);
                Q7Project movedFromInfo = (Q7Project)RcpttCore.create(movedFromRes.getProject());
                IQ7Element.HandleType movedFromType = element.getParent().getElementType();
                this.currentElement = null;
                Openable movedFromElement = this.createElement((IResource)movedFromRes, movedFromType, movedFromInfo);
                if (movedFromElement == null) {
                    this.currentDelta().added(element);
                } else {
                    this.currentDelta().movedTo(element, movedFromElement);
                }
            }
            switch (elementType) {
                case Folder: {
                    Q7Project project = (Q7Project)element.getQ7Project();
                    this.projectCachesToReset.add(project);
                }
            }
        }
    }

    private void elementRemoved(Openable element, IResourceDelta delta, Q7Project rootInfo) throws InterruptedException {
        IQ7Element.HandleType elementType = element.getElementType();
        if (delta == null || (delta.getFlags() & 0x2000) == 0) {
            if (this.isWorkingCopy(element, elementType)) {
                this.currentDelta().changed(element, 262144);
            } else {
                this.close(element);
                this.removeFromParentInfo(element);
                this.currentDelta().removed(element);
            }
        } else {
            IFolder movedToRes;
            this.close(element);
            this.removeFromParentInfo(element);
            IPath movedToPath = delta.getMovedToPath();
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 4: {
                    movedToRes = res.getWorkspace().getRoot().getProject(movedToPath.lastSegment());
                    break;
                }
                case 2: {
                    movedToRes = res.getWorkspace().getRoot().getFolder(movedToPath);
                    break;
                }
                case 1: {
                    movedToRes = res.getWorkspace().getRoot().getFile(movedToPath);
                    break;
                }
                default: {
                    return;
                }
            }
            Q7Project movedToInfo = (Q7Project)RcpttCore.create(movedToRes.getProject());
            IQ7Element.HandleType movedToType = element.getElementType();
            this.currentElement = null;
            Openable movedToElement = this.createElement((IResource)movedToRes, movedToType, movedToInfo);
            if (movedToElement == null) {
                this.currentDelta().removed(element);
            } else {
                this.currentDelta().movedFrom(element, movedToElement);
            }
        }
        switch (elementType) {
            case Model: {
                this.manager.getIndexManager().reset();
                break;
            }
            case Project: {
                IQ7Project project = (IQ7Project)((Object)element);
                this.rootsToRefresh.add(project);
                this.projectCachesToReset.add(project);
                break;
            }
            case Folder: {
                IQ7Project project = element.getQ7Project();
                this.projectCachesToReset.add(project);
            }
        }
    }

    public void flush() {
        this.modelDeltas = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(IQ7ElementDelta customDelta, int eventType) {
        int listenerCount;
        int[] listenerMask;
        IElementChangedListener[] listeners;
        if (!this.isFiring) {
            return;
        }
        if (DEBUG) {
            System.out.println("-----------------------------------------------------------------------------------------------------------------------");
        }
        IQ7ElementDelta deltaToNotify = customDelta == null ? this.mergeDeltas(this.modelDeltas) : customDelta;
        DeltaProcessingState deltaProcessingState = this.state;
        synchronized (deltaProcessingState) {
            listeners = this.state.elementChangedListeners;
            listenerMask = this.state.elementChangedListenerMasks;
            listenerCount = this.state.elementChangedListenerCount;
        }
        switch (eventType) {
            case 0: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
                break;
            }
            case 1: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
            }
        }
    }

    private void firePostChangeDelta(IQ7ElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (DEBUG) {
            System.out.println("FIRING POST_CHANGE Delta [" + String.valueOf(Thread.currentThread()) + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.flush();
            this.notifyListeners(deltaToNotify, 1, listeners, listenerMask, listenerCount);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        IQ7ElementDelta deltaToNotify = this.mergeDeltas(this.reconcileDeltas.values());
        if (DEBUG) {
            System.out.println("FIRING POST_RECONCILE Delta [" + String.valueOf(Thread.currentThread()) + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(deltaToNotify, 4, listeners, listenerMask, listenerCount);
        }
    }

    private boolean isAffectedBy(IResourceDelta rootDelta) {
        if (rootDelta != null) {
            class FoundRelevantDeltaException
            extends RuntimeException {
                private static final long serialVersionUID = 7137113252936111022L;

                FoundRelevantDeltaException() {
                }
            }
            try {
                rootDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        switch (delta.getKind()) {
                            case 1: 
                            case 2: {
                                throw new FoundRelevantDeltaException();
                            }
                            case 4: {
                                if (delta.getAffectedChildren().length != 0 || (delta.getFlags() & 0xFFFCFFFF) == 0) break;
                                throw new FoundRelevantDeltaException();
                            }
                        }
                        return true;
                    }
                });
            }
            catch (FoundRelevantDeltaException e) {
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isWorkingCopy(IQ7Element element, IQ7Element.HandleType elementType) {
        if (elementType.equals((Object)IQ7Element.HandleType.Context) || elementType.equals((Object)IQ7Element.HandleType.Verification) || elementType.equals((Object)IQ7Element.HandleType.TestCase) || elementType.equals((Object)IQ7Element.HandleType.TestSuite)) {
            IQ7NamedElement cu = (IQ7NamedElement)element;
            return cu.isWorkingCopy();
        }
        return false;
    }

    private IQ7ElementDelta mergeDeltas(Collection deltas) {
        if (deltas.size() == 0) {
            return null;
        }
        if (deltas.size() == 1) {
            return (IQ7ElementDelta)deltas.iterator().next();
        }
        if (VERBOSE) {
            System.out.println("MERGING " + deltas.size() + " DELTAS [" + String.valueOf(Thread.currentThread()) + "]");
        }
        Iterator iterator = deltas.iterator();
        Q7ElementDelta rootDelta = new Q7ElementDelta(this.manager.getModel());
        boolean insertedTree = false;
        while (iterator.hasNext()) {
            Q7ElementDelta delta = (Q7ElementDelta)iterator.next();
            if (VERBOSE) {
                System.out.println(delta.toString());
            }
            IQ7Element element = delta.getElement();
            if (this.manager.getModel().equals(element)) {
                IQ7ElementDelta[] children = delta.getAffectedChildren();
                int j = 0;
                while (j < children.length) {
                    Q7ElementDelta projectDelta = (Q7ElementDelta)children[j];
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++j;
                }
                IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                if (resourceDeltas == null) continue;
                int i = 0;
                int length = resourceDeltas.length;
                while (i < length) {
                    rootDelta.addResourceDelta(resourceDeltas[i]);
                    insertedTree = true;
                    ++i;
                }
                continue;
            }
            rootDelta.insertDeltaTree(element, delta);
            insertedTree = true;
        }
        if (insertedTree) {
            return rootDelta;
        }
        return null;
    }

    private void notifyListeners(IQ7ElementDelta deltaToNotify, int eventType, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        final Q7ElementChangedEvent extraEvent = new Q7ElementChangedEvent(deltaToNotify, eventType);
        int i = 0;
        while (i < listenerCount) {
            if ((listenerMask[i] & eventType) != 0) {
                final IElementChangedListener listener = listeners[i];
                long start = -1L;
                if (VERBOSE) {
                    System.out.print("Listener #" + (i + 1) + "=" + listener.toString());
                    start = System.currentTimeMillis();
                }
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        exception.printStackTrace();
                    }

                    public void run() throws Exception {
                        listener.elementChanged(extraEvent);
                    }
                });
                if (VERBOSE) {
                    System.out.println(" -> " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            ++i;
        }
    }

    private void nonQ7ResourcesChanged(Openable element, IResourceDelta delta) throws ModelException, InterruptedException {
        boolean cont = element.accessInfoIfOpened(info -> {
            switch (element.getElementType()) {
                case Model: {
                    ((ModelInfo)info).foreignResources = null;
                    this.currentDelta().addResourceDelta(delta);
                    return false;
                }
                case Project: {
                    ((Q7ProjectInfo)info).setForeignResources(null);
                    break;
                }
                case Folder: {
                    ((Q7FolderInfo)info).setForeignResources(null);
                }
            }
            return true;
        }).orElse(true);
        if (!cont) {
            return;
        }
        Q7ElementDelta current = this.currentDelta();
        Q7ElementDelta elementDelta = current.find(element);
        if (elementDelta == null) {
            elementDelta = current.changed(element, 1);
        }
        elementDelta.addResourceDelta(delta);
    }

    private void popUntilPrefixOf(IPath path) {
        while (this.currentElement != null) {
            IPath currentElementPath = null;
            IResource currentElementResource = this.currentElement.getResource();
            if (currentElementResource != null) {
                currentElementPath = currentElementResource.getFullPath();
            }
            if (currentElementPath != null) {
                if (this.currentElement instanceof IQ7Folder && ((IQ7Folder)((Object)this.currentElement)).isRootFolder() && currentElementPath.segmentCount() != path.segmentCount() - 1) {
                    this.currentElement = (Openable)this.currentElement.getParent();
                }
                if (currentElementPath.isPrefixOf(path)) {
                    return;
                }
            }
            this.currentElement = (Openable)this.currentElement.getParent();
        }
    }

    private IQ7ElementDelta processResourceDelta(IResourceDelta changes) throws InterruptedException {
        try {
            Q7Model model = this.manager.getModel();
            try {
                model.openAndAccessInfo(ignored -> null, null);
            }
            catch (ModelException e) {
                throw new AssertionError((Object)e);
            }
            this.currentElement = null;
            IResourceDelta[] deltas = changes.getAffectedChildren();
            int i = 0;
            while (i < deltas.length) {
                IQ7Element.HandleType elementType;
                IResourceDelta delta = deltas[i];
                IResource res = delta.getResource();
                Q7Project rootInfo = null;
                IProject proj = (IProject)res;
                boolean wasQ7Project = this.state.findProject(proj.getName()) != null;
                boolean isDylanProject = RcpttCore.hasRcpttNature(proj);
                if (!wasQ7Project && !isDylanProject) {
                    elementType = IQ7Element.HandleType.NonQ7;
                } else {
                    rootInfo = (Q7Project)RcpttCore.create(res.getProject());
                    elementType = IQ7Element.HandleType.Project;
                }
                HashSet<IQ7NamedElement> toIndex = new HashSet<IQ7NamedElement>();
                this.traverseDelta(delta, elementType, rootInfo, toIndex);
                if (toIndex.size() > 0) {
                    ProjectIndexerManager.indexNamedElements(toIndex);
                }
                if (elementType.equals((Object)IQ7Element.HandleType.NonQ7) || wasQ7Project != isDylanProject && delta.getKind() == 4) {
                    try {
                        this.nonQ7ResourcesChanged(model, delta);
                    }
                    catch (ModelException modelException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            this.resetProjectCaches();
            this.executePostActions();
            Q7ElementDelta q7ElementDelta = this.currentDelta;
            return q7ElementDelta;
        }
        finally {
            this.currentDelta = null;
            this.rootsToRefresh.clear();
            this.projectCachesToReset.clear();
            this.postActions.clear();
        }
    }

    private void executePostActions() {
        if (this.postActions.size() == 0) {
            return;
        }
        Iterator<Runnable> i = this.postActions.iterator();
        while (i.hasNext()) {
            i.next().run();
        }
    }

    private void resetProjectCaches() {
        if (this.projectCachesToReset.size() == 0) {
            return;
        }
        Iterator<IQ7Project> iterator = this.projectCachesToReset.iterator();
        HashMap projectDepencies = this.state.projectDependencies;
        HashSet affectedDependents = new HashSet();
        while (iterator.hasNext()) {
            Q7Project project = (Q7Project)iterator.next();
            project.resetCaches();
            this.addDependentProjects(project, projectDepencies, affectedDependents);
        }
        for (Q7Project project : affectedDependents) {
            project.resetCaches();
        }
    }

    public void registerModelDelta(IQ7ElementDelta delta) {
        this.modelDeltas.add(delta);
    }

    private void removeFromParentInfo(Openable child) throws InterruptedException {
        Openable parent = (Openable)child.getParent();
        if (parent == null) {
            return;
        }
        parent.accessInfo(info -> {
            OpenableElementInfo openable2 = (OpenableElementInfo)info;
            if (openable2.isStructureKnown()) {
                info.removeChild(child);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resourceChanged(IResourceChangeEvent event) throws InterruptedException {
        int eventType = this.overridenEventType == -1 ? event.getType() : this.overridenEventType;
        IResource resource = event.getResource();
        IResourceDelta delta = event.getDelta();
        switch (eventType) {
            case 4: {
                if (resource.getType() != 4 || !RcpttCore.hasRcpttNature((IProject)resource)) return;
                this.deleting((IProject)resource);
                return;
            }
            case 1: {
                if (!this.isAffectedBy(delta)) return;
                try {
                    try {
                        IQ7ElementDelta translatedDelta;
                        this.stopDeltas();
                        this.checkProjectsBeingAddedOrRemoved(delta);
                        if (this.refreshedElements != null) {
                            HashSet<IQ7Element> refreshedElementsCopy = null;
                            if (this.refreshedElements != null) {
                                refreshedElementsCopy = new HashSet<IQ7Element>();
                                refreshedElementsCopy.addAll(this.refreshedElements);
                                this.refreshedElements = null;
                            }
                        }
                        if ((translatedDelta = this.processResourceDelta(delta)) != null) {
                            this.registerModelDelta(translatedDelta);
                        }
                    }
                    finally {
                        this.startDeltas();
                    }
                    this.updateModel(null);
                    DeltaProcessingState deltaProcessingState = this.state;
                    synchronized (deltaProcessingState) {
                        IElementChangedListener[] listeners = this.state.elementChangedListeners;
                    }
                    this.fire(null, 1);
                    return;
                }
                finally {
                    this.state.resetOldProjectNames();
                }
            }
            case 8: {
                if (this.isAffectedBy(delta)) return;
                return;
            }
            case 16: {
                return;
            }
        }
    }

    private void startDeltas() {
        this.isFiring = true;
    }

    private void stopDeltas() {
        this.isFiring = false;
    }

    private void traverseDelta(IResourceDelta delta, IQ7Element.HandleType elementType, Q7Project rootInfo, Set<IQ7NamedElement> toIndex) throws InterruptedException {
        IResource res = delta.getResource();
        if (this.currentElement == null && rootInfo != null) {
            this.currentElement = rootInfo;
        }
        boolean processChildren = true;
        processChildren = res instanceof IProject ? this.updateCurrentDeltaAndIndex(delta, elementType, rootInfo, toIndex) : (rootInfo != null ? this.updateCurrentDeltaAndIndex(delta, elementType, rootInfo, toIndex) : true);
        if (processChildren) {
            IResourceDelta[] children = delta.getAffectedChildren();
            int length = children.length;
            int i = 0;
            while (i < length) {
                IResourceDelta child = children[i];
                IResource childRes = child.getResource();
                int childKind = childRes.getType();
                IQ7Element.HandleType childType = this.elementType(childRes, childKind, rootInfo);
                this.traverseDelta(child, childType, rootInfo, toIndex);
                ++i;
            }
        }
    }

    private IQ7Element.HandleType elementType(IResource childRes, int childKind, Q7Project rootInfo) {
        switch (childKind) {
            case 2: {
                return IQ7Element.HandleType.Folder;
            }
            case 4: {
                return IQ7Element.HandleType.Project;
            }
            case 8: {
                return IQ7Element.HandleType.Model;
            }
            case 1: {
                IPath childPath = childRes.getFullPath();
                if (!RcpttCore.isQ7File(childPath)) break;
                if (RcpttCore.isQ7Context(childPath)) {
                    return IQ7Element.HandleType.Context;
                }
                if (RcpttCore.isQ7Verification(childPath)) {
                    return IQ7Element.HandleType.Verification;
                }
                if (RcpttCore.isQ7TestSuite(childPath)) {
                    return IQ7Element.HandleType.TestSuite;
                }
                if (RcpttCore.isQ7ProjectMetadata(childPath)) {
                    return IQ7Element.HandleType.ProjectMetadata;
                }
                return IQ7Element.HandleType.TestCase;
            }
        }
        return IQ7Element.HandleType.NonQ7;
    }

    public boolean updateCurrentDeltaAndIndex(IResourceDelta delta, IQ7Element.HandleType elementType, Q7Project rootInfo, Set<IQ7NamedElement> toIndex) throws InterruptedException {
        switch (delta.getKind()) {
            case 1: {
                IResource deltaRes = delta.getResource();
                Openable element = this.createElement(deltaRes, elementType, rootInfo);
                if (element == null) {
                    return true;
                }
                this.updateIndex(element, delta, toIndex);
                this.elementAdded(element, delta);
                return elementType.equals((Object)IQ7Element.HandleType.Folder);
            }
            case 2: {
                IResource deltaRes = delta.getResource();
                Openable element = this.createElement(deltaRes, elementType, rootInfo);
                if (element == null) {
                    return true;
                }
                this.updateIndex(element, delta, toIndex);
                this.elementRemoved(element, delta, rootInfo);
                return elementType.equals((Object)IQ7Element.HandleType.Folder);
            }
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x100) != 0 || (flags & 0x100000) != 0) {
                    Openable element = this.createElement(delta.getResource(), elementType, rootInfo);
                    if (element == null) {
                        return false;
                    }
                    this.updateIndex(element, delta, toIndex);
                    this.contentChanged(element);
                } else if (elementType.equals((Object)IQ7Element.HandleType.Project)) {
                    if ((flags & 0x4000) != 0) {
                        final IProject res = (IProject)delta.getResource();
                        Openable element = this.createElement((IResource)res, elementType, rootInfo);
                        if (element == null) {
                            return false;
                        }
                        if (res.isOpen()) {
                            if (RcpttCore.hasRcpttNature(res)) {
                                this.addToParentInfo(element);
                                this.currentDelta().opened(element);
                                IQ7Project project = (IQ7Project)((Object)element);
                                this.rootsToRefresh.add(project);
                                this.projectCachesToReset.add(project);
                                this.postActions.add(new Runnable(){

                                    @Override
                                    public void run() {
                                        ProjectIndexerManager.indexProject(res);
                                    }
                                });
                            }
                        } else if (this.state.findProject(res.getName()) != null) {
                            this.close(element);
                            this.removeFromParentInfo(element);
                            this.currentDelta().closed(element);
                            this.manager.getIndexManager().discardJobs(element.getName());
                            IPath projectPath = res.getFullPath();
                            this.manager.getIndexManager().removeIndex(projectPath);
                            ProjectIndexerManager.removeProject(projectPath);
                        }
                        return false;
                    }
                    if ((flags & 0x80000) != 0) {
                        IProject res = (IProject)delta.getResource();
                        boolean isQ7Project = RcpttCore.hasRcpttNature(res);
                        Openable element = this.createElement((IResource)res, elementType, rootInfo);
                        if (element == null) {
                            return false;
                        }
                        if (isQ7Project) {
                            this.elementAdded(element, delta);
                            ProjectIndexerManager.indexProject(res);
                        } else {
                            this.elementRemoved(element, delta, rootInfo);
                            this.manager.getIndexManager().discardJobs(element.getName());
                            IPath projectPath = res.getFullPath();
                            this.manager.getIndexManager().removeIndex(projectPath);
                            ProjectIndexerManager.removeProject(projectPath);
                        }
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateIndex(Openable element, IResourceDelta delta, Set<IQ7NamedElement> toIndex) {
        IndexManager indexManager = this.manager.getIndexManager();
        if (indexManager == null) {
            return;
        }
        block0 : switch (element.getElementType()) {
            case Project: {
                switch (delta.getKind()) {
                    case 1: {
                        final IQ7Project q7Project = element.getQ7Project();
                        this.postActions.add(new Runnable(){

                            @Override
                            public void run() {
                                ProjectIndexerManager.indexProject(q7Project);
                            }
                        });
                        return;
                    }
                    case 2: {
                        IPath projectPath = element.getQ7Project().getProject().getFullPath();
                        indexManager.removeIndex(projectPath);
                        ProjectIndexerManager.removeProject(projectPath);
                    }
                }
                return;
            }
            case Folder: {
                switch (delta.getKind()) {
                    case 1: 
                    case 2: {
                        IQ7Folder pkg = null;
                        if (element instanceof IQ7Project) {
                            IQ7Project root = (IQ7Project)((Object)element);
                            pkg = root.getFolder((IPath)Path.EMPTY);
                        } else {
                            pkg = (IQ7Folder)((Object)element);
                        }
                        IResourceDelta[] children = delta.getAffectedChildren();
                        int i = 0;
                        int length = children.length;
                        while (i < length) {
                            IResourceDelta child = children[i];
                            IResource resource = child.getResource();
                            if (resource instanceof IFile) {
                                String name = resource.getName();
                                if (RcpttCore.isQ7File(resource.getFullPath())) {
                                    Openable cu = (Openable)((Object)pkg.getNamedElement(name));
                                    this.updateIndex(cu, child, toIndex);
                                }
                            }
                            ++i;
                        }
                        return;
                    }
                }
                return;
            }
            case TestCase: 
            case Context: 
            case TestSuite: 
            case ProjectMetadata: 
            case Verification: {
                IFile file = (IFile)delta.getResource();
                switch (delta.getKind()) {
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x100) == 0 && (flags & 0x100000) == 0) return;
                    }
                    case 1: {
                        if (!ProjectIndexerManager.isIndexerEnabled(file.getProject())) return;
                        toIndex.add((IQ7NamedElement)((Object)element));
                        break block0;
                    }
                    case 2: {
                        IProject project = file.getProject();
                        String path = file.getFullPath().removeFirstSegments(1).toString();
                        ProjectIndexerManager.removeNamedElement(RcpttCore.create(project), path);
                    }
                }
            }
        }
    }

    public void updateModel(IQ7ElementDelta customDelta) throws InterruptedException {
        if (customDelta == null) {
            int i = 0;
            int length = this.modelDeltas.size();
            while (i < length) {
                IQ7ElementDelta delta = this.modelDeltas.get(i);
                this.modelUpdater.processDelta(delta);
                ++i;
            }
        } else {
            this.modelUpdater.processDelta(customDelta);
        }
    }
}

