/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.ReplaceDeprecatedFieldFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessorUtil;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class ReplaceDeprecatedFieldCleanUpCore
extends AbstractMultiFix {
    public ReplaceDeprecatedFieldCleanUpCore() {
        this(Collections.emptyMap());
    }

    public ReplaceDeprecatedFieldCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.replace_deprecated_fields");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.replace_deprecated_fields")) {
            return new String[]{MultiFixMessages.ReplaceDeprecatedFieldsCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        bld.append("Class E {\n");
        bld.append("  /**\n");
        bld.append("   * @deprecated use {@link K#field2} instead\n");
        bld.append("   */\n");
        bld.append("  @Deprecated\n");
        bld.append("  public int field1;\n");
        bld.append("}\n\n");
        if (this.isEnabled("cleanup.replace_deprecated_fields")) {
            bld.append("return K.field2;\n");
        } else {
            bld.append("return E.field1;\n");
        }
        return bld.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (!this.isEnabled("cleanup.replace_deprecated_fields")) {
            return null;
        }
        if (compilationUnit == null) {
            return null;
        }
        final ArrayList deprecatedFields = new ArrayList();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(QualifiedName node) {
                String replacement = QuickAssistProcessorUtil.getDeprecatedFieldReplacement((ASTNode)node);
                if (replacement != null) {
                    deprecatedFields.add(new ReplaceDeprecatedFieldFixCore.ReplaceDeprecatedFieldProposalOperation((ASTNode)node, replacement));
                }
                return false;
            }

            public boolean visit(SimpleName node) {
                if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY) {
                    return true;
                }
                String replacement = QuickAssistProcessorUtil.getDeprecatedFieldReplacement((ASTNode)node);
                if (replacement != null) {
                    deprecatedFields.add(new ReplaceDeprecatedFieldFixCore.ReplaceDeprecatedFieldProposalOperation((ASTNode)node, replacement));
                }
                return false;
            }

            public boolean visit(FieldAccess node) {
                String replacement = QuickAssistProcessorUtil.getDeprecatedFieldReplacement((ASTNode)node);
                if (replacement != null) {
                    deprecatedFields.add(new ReplaceDeprecatedFieldFixCore.ReplaceDeprecatedFieldProposalOperation((ASTNode)node, replacement));
                }
                return false;
            }

            public boolean visit(SuperFieldAccess node) {
                String replacement = QuickAssistProcessorUtil.getDeprecatedFieldReplacement((ASTNode)node);
                if (replacement != null) {
                    deprecatedFields.add(new ReplaceDeprecatedFieldFixCore.ReplaceDeprecatedFieldProposalOperation((ASTNode)node, replacement));
                }
                return false;
            }
        };
        compilationUnit.accept(visitor);
        if (deprecatedFields.isEmpty()) {
            return null;
        }
        return new ReplaceDeprecatedFieldFixCore(this.getPreview(), compilationUnit, deprecatedFields.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        if (!this.isEnabled("cleanup.replace_deprecated_fields")) {
            return 0;
        }
        if (compilationUnit == null) {
            return 0;
        }
        final ArrayList deprecatedFields = new ArrayList();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(QualifiedName node) {
                if (QuickAssistProcessorUtil.getDeprecatedFieldReplacement((ASTNode)node) != null) {
                    deprecatedFields.add(node);
                }
                return true;
            }

            public boolean visit(FieldAccess node) {
                if (QuickAssistProcessorUtil.getDeprecatedFieldReplacement((ASTNode)node) != null) {
                    deprecatedFields.add(node);
                }
                return true;
            }

            public boolean visit(SuperFieldAccess node) {
                if (QuickAssistProcessorUtil.getDeprecatedFieldReplacement((ASTNode)node) != null) {
                    deprecatedFields.add(node);
                }
                return true;
            }
        };
        compilationUnit.accept(visitor);
        return deprecatedFields.size();
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }
}

