/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.manipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.core.manipulation.dom.OperatorPrecedence;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class SourceAnalyzer {
    private ITypeRoot fTypeRoot;
    private MethodDeclaration fDeclaration;
    private Map<IVariableBinding, ParameterData> fParameters;
    private Map<IBinding, NameData> fNames;
    private List<Expression> fImplicitReceivers;
    private boolean fArrayAccess;
    private boolean fHasSuperMethodInvocation;
    private boolean fHasSuperFieldAccess;
    private List<SimpleName> fTypesToImport;
    private List<SimpleName> fStaticsToImport;
    private List<NameData> fTypeParameterReferences;
    private Map<ITypeBinding, NameData> fTypeParameterMapping;
    private List<NameData> fMethodTypeParameterReferences;
    private Map<ITypeBinding, NameData> fMethodTypeParameterMapping;
    private boolean fInterruptedExecutionFlow;
    private boolean fAccessesPrivate;
    private boolean fAccessesProtected;
    private boolean fAccessesPackagePrivate;

    public SourceAnalyzer(ITypeRoot typeRoot, MethodDeclaration declaration) {
        this.fTypeRoot = typeRoot;
        this.fDeclaration = declaration;
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fInterruptedExecutionFlow;
    }

    public RefactoringStatus checkActivation() throws JavaModelException {
        List parameters;
        RefactoringStatus result = new RefactoringStatus();
        if (!this.fTypeRoot.isStructureKnown()) {
            result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_syntax_errors, JavaStatusContext.create(this.fTypeRoot));
            return result;
        }
        IProblem[] problems = ASTNodes.getProblems((ASTNode)this.fDeclaration, 0, 2);
        if (problems.length > 0) {
            result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
            return result;
        }
        IMethodBinding declarationBinding = this.fDeclaration.resolveBinding();
        if (declarationBinding != null) {
            int modifiers = declarationBinding.getModifiers();
            if (Modifier.isAbstract((int)modifiers)) {
                result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_abstract_methods, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
                return result;
            }
            if (Modifier.isNative((int)modifiers)) {
                result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_native_methods, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
                return result;
            }
        } else {
            result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_methoddeclaration_has_errors, JavaStatusContext.create(this.fTypeRoot));
            return result;
        }
        AccessAnalyzer accessAnalyzer = new AccessAnalyzer();
        this.fDeclaration.accept((ASTVisitor)accessAnalyzer);
        this.fAccessesPrivate = accessAnalyzer.accessesPrivate;
        this.fAccessesProtected = accessAnalyzer.accessesProtected;
        this.fAccessesPackagePrivate = accessAnalyzer.accessesPackagePrivate;
        ActivationAnalyzer analyzer = new ActivationAnalyzer();
        this.fDeclaration.accept((ASTVisitor)analyzer);
        result.merge(analyzer.status);
        if (!result.hasFatalError()) {
            parameters = this.fDeclaration.parameters();
            this.fParameters = new HashMap<IVariableBinding, ParameterData>(parameters.size() * 2);
            for (SingleVariableDeclaration element : parameters) {
                IVariableBinding binding = element.resolveBinding();
                if (binding == null) {
                    result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
                    return result;
                }
                this.fParameters.put(binding, (ParameterData)element.getProperty(ParameterData.PROPERTY));
            }
            this.fNames = new HashMap<IBinding, NameData>();
            this.fImplicitReceivers = new ArrayList<Expression>(2);
            this.fTypeParameterReferences = new ArrayList<NameData>(0);
            this.fTypeParameterMapping = new HashMap<ITypeBinding, NameData>();
            ITypeBinding declaringType = declarationBinding.getDeclaringClass();
            if (declaringType == null) {
                result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_typedeclaration_has_errors, JavaStatusContext.create(this.fTypeRoot));
                return result;
            }
            ITypeBinding[] iTypeBindingArray = declaringType.getTypeParameters();
            int n = iTypeBindingArray.length;
            int binding = 0;
            while (binding < n) {
                ITypeBinding typeParameter = iTypeBindingArray[binding];
                NameData data = new NameData(typeParameter.getName());
                this.fTypeParameterReferences.add(data);
                this.fTypeParameterMapping.put(typeParameter, data);
                ++binding;
            }
            this.fMethodTypeParameterReferences = new ArrayList<NameData>(0);
            this.fMethodTypeParameterMapping = new HashMap<ITypeBinding, NameData>();
            IMethodBinding method = declarationBinding;
            ITypeBinding[] iTypeBindingArray2 = method.getTypeParameters();
            int n2 = iTypeBindingArray2.length;
            n = 0;
            while (n < n2) {
                ITypeBinding typeParameter = iTypeBindingArray2[n];
                NameData data = new NameData(typeParameter.getName());
                this.fMethodTypeParameterReferences.add(data);
                this.fMethodTypeParameterMapping.put(typeParameter, data);
                ++n;
            }
        }
        if (this.fDeclaration.isVarargs()) {
            parameters = this.fDeclaration.parameters();
            VarargAnalyzer vAnalyzer = new VarargAnalyzer(((SingleVariableDeclaration)parameters.get(parameters.size() - 1)).getName().resolveBinding());
            this.fDeclaration.getBody().accept((ASTVisitor)vAnalyzer);
        }
        return result;
    }

    public void initialize() {
        Block body = this.fDeclaration.getBody();
        this.fTypesToImport = new ArrayList<SimpleName>();
        this.fStaticsToImport = new ArrayList<SimpleName>();
        ImportReferencesCollector.collect((ASTNode)body, this.fTypeRoot.getJavaProject(), null, this.fTypesToImport, this.fStaticsToImport);
        body.accept((ASTVisitor)new UpdateCollector());
        int numberOfLocals = LocalVariableIndex.perform((BodyDeclaration)this.fDeclaration);
        FlowContext context = new FlowContext(0, numberOfLocals + 1);
        context.setConsiderAccessMode(true);
        context.setComputeMode(FlowContext.MERGE);
        InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(context);
        FlowInfo info = flowAnalyzer.perform(this.getStatements());
        for (SingleVariableDeclaration element : this.fDeclaration.parameters()) {
            IVariableBinding binding = element.resolveBinding();
            ParameterData data = (ParameterData)element.getProperty(ParameterData.PROPERTY);
            data.setAccessMode(info.getAccessMode(context, binding));
        }
    }

    public Collection<NameData> getUsedNames() {
        return this.fNames.values();
    }

    public List<Expression> getImplicitReceivers() {
        return this.fImplicitReceivers;
    }

    public List<SimpleName> getTypesToImport() {
        return this.fTypesToImport;
    }

    public List<SimpleName> getStaticsToImport() {
        return this.fStaticsToImport;
    }

    public List<NameData> getTypeParameterReferences() {
        return this.fTypeParameterReferences;
    }

    public List<NameData> getMethodTypeParameterReferences() {
        return this.fMethodTypeParameterReferences;
    }

    public boolean hasArrayAccess() {
        return this.fArrayAccess;
    }

    public boolean hasSuperMethodInvocation() {
        return this.fHasSuperMethodInvocation;
    }

    public boolean hasSuperFieldAccess() {
        return this.fHasSuperFieldAccess;
    }

    private ASTNode[] getStatements() {
        List statements = this.fDeclaration.getBody().statements();
        return statements.toArray(new ASTNode[statements.size()]);
    }

    public boolean accessesPrivate() {
        return this.fAccessesPrivate;
    }

    public boolean accessesProtected() {
        return this.fAccessesProtected;
    }

    public boolean accessesPackagePrivate() {
        return this.fAccessesPackagePrivate;
    }

    public boolean onlyAccessesPublic() {
        return !this.fAccessesPrivate && !this.fAccessesProtected && !this.fAccessesPackagePrivate;
    }

    private class AccessAnalyzer
    extends ASTVisitor {
        public boolean accessesPrivate;
        public boolean accessesProtected;
        public boolean accessesPackagePrivate;

        private AccessAnalyzer() {
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null) {
                int modifiers = binding.getModifiers();
                boolean isPublic = Modifier.isPublic((int)modifiers);
                boolean isPrivate = Modifier.isPrivate((int)modifiers);
                boolean isProtected = Modifier.isProtected((int)modifiers);
                if (!isPublic) {
                    if (binding instanceof IVariableBinding) {
                        IVariableBinding varBinding = (IVariableBinding)binding;
                        ITypeBinding declClass = varBinding.getDeclaringClass();
                        if (!varBinding.isField() || declClass == null || declClass.isLocal()) {
                            return true;
                        }
                    } else if (binding instanceof IMethodBinding) {
                        IMethodBinding methodBinding = (IMethodBinding)binding;
                        ITypeBinding declClass = methodBinding.getDeclaringClass();
                        if (declClass == null || declClass.isLocal()) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                this.accessesPrivate = this.accessesPrivate || isPrivate;
                this.accessesProtected = this.accessesProtected || isProtected;
                this.accessesPackagePrivate = this.accessesPackagePrivate || !isPublic && !isPrivate && !isProtected;
            }
            return true;
        }
    }

    private class ActivationAnalyzer
    extends ASTVisitor {
        public RefactoringStatus status = new RefactoringStatus();
        private ASTNode fLastNode = this.getLastNode();
        private IMethodBinding fBinding = this.getBinding();

        private ActivationAnalyzer() {
        }

        public boolean visit(ReturnStatement node) {
            if (node != this.fLastNode) {
                SourceAnalyzer.this.fInterruptedExecutionFlow = true;
            }
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            return false;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(LambdaExpression node) {
            return false;
        }

        public boolean visit(MethodInvocation node) {
            IMethodBinding methodBinding = node.resolveMethodBinding();
            if (methodBinding != null) {
                methodBinding.getMethodDeclaration();
            }
            if (this.fBinding != null && methodBinding != null && this.fBinding.isEqualTo((IBinding)methodBinding) && !this.status.hasFatalError()) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_recursive_call);
                return false;
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding == null && !this.status.hasFatalError() && !ASTNodes.isLabel(node)) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(SourceAnalyzer.this.fTypeRoot, (ASTNode)SourceAnalyzer.this.fDeclaration));
                return false;
            }
            return true;
        }

        public boolean visit(ThisExpression node) {
            if (node.getQualifier() != null) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_qualified_this_expressions, JavaStatusContext.create(SourceAnalyzer.this.fTypeRoot, (ASTNode)node));
                return false;
            }
            return true;
        }

        private ASTNode getLastNode() {
            List statements = SourceAnalyzer.this.fDeclaration.getBody().statements();
            if (statements.size() == 0) {
                return null;
            }
            return (ASTNode)statements.get(statements.size() - 1);
        }

        private IMethodBinding getBinding() {
            IMethodBinding result = SourceAnalyzer.this.fDeclaration.resolveBinding();
            if (result != null) {
                return result.getMethodDeclaration();
            }
            return result;
        }
    }

    public static class NameData {
        private String fName;
        private List<SimpleName> fReferences;

        public NameData(String n) {
            this.fName = n;
            this.fReferences = new ArrayList<SimpleName>(2);
        }

        public String getName() {
            return this.fName;
        }

        public void addReference(SimpleName ref) {
            this.fReferences.add(ref);
        }

        public List<SimpleName> references() {
            return this.fReferences;
        }
    }

    private class UpdateCollector
    extends ASTVisitor {
        private int fTypeCounter;

        private UpdateCollector() {
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public void endVisit(TypeDeclaration node) {
            --this.fTypeCounter;
        }

        public boolean visit(EnumDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public void endVisit(EnumDeclaration node) {
            --this.fTypeCounter;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public void endVisit(AnnotationTypeDeclaration node) {
            --this.fTypeCounter;
        }

        private boolean visitType(AbstractTypeDeclaration node) {
            if (this.fTypeCounter++ == 0) {
                this.addNameReference(node.getName());
            }
            return true;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            ++this.fTypeCounter;
            return true;
        }

        public void endVisit(AnonymousClassDeclaration node) {
            --this.fTypeCounter;
        }

        public boolean visit(FieldAccess node) {
            node.getExpression().accept((ASTVisitor)this);
            this.addReferencesToName(node.getName());
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            AbstractTypeDeclaration decl;
            NameData name;
            if (node.isConstructor() && (name = SourceAnalyzer.this.fNames.get((decl = ASTNodes.getParent((ASTNode)node, AbstractTypeDeclaration.class)).getName().resolveBinding())) != null) {
                name.addReference(node.getName());
            }
            return true;
        }

        public boolean visit(MethodInvocation node) {
            Expression receiver;
            if (this.fTypeCounter == 0 && (receiver = node.getExpression()) == null && !this.isStaticallyImported((Name)node.getName())) {
                SourceAnalyzer.this.fImplicitReceivers.add((Expression)node);
            }
            return true;
        }

        public boolean visit(SuperMethodInvocation node) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fHasSuperMethodInvocation = true;
            }
            return true;
        }

        public boolean visit(SuperFieldAccess node) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fHasSuperFieldAccess = true;
            }
            return true;
        }

        public boolean visit(SuperConstructorInvocation node) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fHasSuperMethodInvocation = true;
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation node) {
            Expression receiver;
            if (this.fTypeCounter == 0 && (receiver = node.getExpression()) == null && node.resolveTypeBinding().isLocal() && !node.resolveTypeBinding().isAnonymous()) {
                SourceAnalyzer.this.fImplicitReceivers.add((Expression)node);
            }
            return true;
        }

        public boolean visit(SingleVariableDeclaration node) {
            if (this.fTypeCounter == 0) {
                this.addNameReference(node.getName());
            }
            return true;
        }

        public boolean visit(VariableDeclarationFragment node) {
            if (this.fTypeCounter == 0) {
                this.addNameReference(node.getName());
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            this.addReferencesToName(node);
            IBinding binding = node.resolveBinding();
            if (binding instanceof ITypeBinding) {
                ITypeBinding type = (ITypeBinding)binding;
                if (type.isTypeVariable()) {
                    this.addTypeVariableReference(type, node);
                }
            } else if (binding instanceof IVariableBinding) {
                int precedence;
                ASTNode parent;
                ParameterData data;
                IVariableBinding vb = (IVariableBinding)binding;
                if (vb.isField() && !this.isStaticallyImported((Name)node)) {
                    StructuralPropertyDescriptor location;
                    Name topName = ASTNodes.getTopMostName((Name)node);
                    if ((node == topName || node == ASTNodes.getLeftMostSimpleName(topName)) && (location = node.getLocationInParent()) != SingleVariableDeclaration.NAME_PROPERTY && location != VariableDeclarationFragment.NAME_PROPERTY) {
                        SourceAnalyzer.this.fImplicitReceivers.add((Expression)node);
                    }
                } else if (!vb.isField() && (data = SourceAnalyzer.this.fParameters.get(binding)) != null && (parent = node.getParent()) instanceof Expression && (precedence = OperatorPrecedence.getExpressionPrecedence((Expression)parent)) != Integer.MAX_VALUE) {
                    data.setOperatorPrecedence(precedence);
                }
            }
            return true;
        }

        public boolean visit(ThisExpression node) {
            Name qualifier;
            IBinding binding;
            Name name;
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fImplicitReceivers.add((Expression)node);
            }
            if ((name = node.getQualifier()) instanceof Name && (binding = (qualifier = name).resolveBinding()) instanceof ITypeBinding) {
                SourceAnalyzer.this.fImplicitReceivers.add((Expression)node);
            }
            return true;
        }

        private void addReferencesToName(SimpleName node) {
            NameData name;
            IBinding binding = node.resolveBinding();
            ParameterData data = SourceAnalyzer.this.fParameters.get(binding);
            if (data != null) {
                data.addReference(node);
            }
            if ((name = SourceAnalyzer.this.fNames.get(binding)) != null) {
                name.addReference(node);
            }
        }

        private void addNameReference(SimpleName name) {
            SourceAnalyzer.this.fNames.put(name.resolveBinding(), new NameData(name.getIdentifier()));
        }

        private void addTypeVariableReference(ITypeBinding variable, SimpleName name) {
            NameData data = SourceAnalyzer.this.fTypeParameterMapping.get(variable);
            if (data == null) {
                data = SourceAnalyzer.this.fMethodTypeParameterMapping.get(variable);
            }
            data.addReference(name);
        }

        private boolean isStaticallyImported(Name name) {
            return SourceAnalyzer.this.fStaticsToImport.contains(name);
        }
    }

    private class VarargAnalyzer
    extends ASTVisitor {
        private IBinding fParameter;

        public VarargAnalyzer(IBinding parameter) {
            this.fParameter = parameter;
        }

        public boolean visit(ArrayAccess node) {
            Expression array = node.getArray();
            if (array instanceof SimpleName && this.fParameter.isEqualTo(((SimpleName)array).resolveBinding())) {
                SourceAnalyzer.this.fArrayAccess = true;
            }
            return true;
        }
    }
}

