/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.EclipsePublisherHelper;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;

public class RemoteFeaturesAction
extends FeaturesAction {
    private UpdateSite updateSite;

    public RemoteFeaturesAction(UpdateSite updateSite) {
        super(null);
        this.updateSite = updateSite;
    }

    public RemoteFeaturesAction(Feature[] features) {
        super(features);
        throw new IllegalArgumentException();
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        try {
            this.info = publisherInfo;
            this.features = this.updateSite.loadFeatures(monitor);
            return super.perform(publisherInfo, results, monitor);
        }
        catch (ProvisionException e) {
            return new Status(4, Activator.ID, NLS.bind((String)Messages.Error_Generation, (Object)this.updateSite), (Throwable)e);
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
    }

    protected void generateFeatureIUs(Feature[] featureList, IPublisherResult result) {
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        extraProperties.put("org.eclipse.equinox.p2.partial.iu", Boolean.TRUE.toString());
        Feature[] featureArray = featureList;
        int n = featureList.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry[] featureEntries;
            Feature feature = featureArray[n2];
            FeatureEntry[] featureEntryArray = featureEntries = feature.getEntries();
            int n3 = featureEntries.length;
            int n4 = 0;
            while (n4 < n3) {
                FeatureEntry entry = featureEntryArray[n4];
                if (entry.isPlugin() && !entry.isRequires()) {
                    IInstallableUnit[] bundleIUs;
                    Hashtable<String, String> mockManifest = new Hashtable<String, String>();
                    ((Dictionary)mockManifest).put("Manifest-Version", "1.0");
                    ((Dictionary)mockManifest).put("Bundle-ManifestVersion", "2");
                    ((Dictionary)mockManifest).put("Bundle-SymbolicName", entry.getId());
                    ((Dictionary)mockManifest).put("Bundle-Version", entry.getVersion());
                    BundleDescription bundleDescription = BundlesAction.createBundleDescription(mockManifest, null);
                    IArtifactKey key = BundlesAction.createBundleArtifactKey((String)entry.getId(), (String)entry.getVersion());
                    IInstallableUnit[] iInstallableUnitArray = bundleIUs = EclipsePublisherHelper.createEclipseIU((BundleDescription)bundleDescription, (boolean)entry.isUnpack(), (IArtifactKey)key, extraProperties);
                    int n5 = bundleIUs.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IInstallableUnit bundleIU = iInstallableUnitArray[n6];
                        result.addIU(bundleIU, "root");
                        ++n6;
                    }
                }
                ++n4;
            }
            IInstallableUnit featureIU = RemoteFeaturesAction.createFeatureJarIU((Feature)feature, (IPublisherInfo)new PublisherInfo());
            ArrayList<IInstallableUnit> childIUs = new ArrayList<IInstallableUnit>();
            childIUs.add(featureIU);
            IInstallableUnit groupIU = this.createGroupIU(feature, childIUs, (IPublisherInfo)new PublisherInfo());
            result.addIU(featureIU, "root");
            result.addIU(groupIU, "root");
            this.generateSiteReferences(feature, result, this.info);
            ++n2;
        }
    }
}

