/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class PullOutIfFromIfElseFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        PullOutIfFromIfElseFinder finder = new PullOutIfFromIfElseFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new PullOutIfFromIfElseFixCore(FixMessages.PullOutIfFromIfElseFix_description, compilationUnit, ops);
    }

    protected PullOutIfFromIfElseFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class PullOutIfFromIfElseFinder
    extends ASTVisitor {
        private List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fResult;

        public PullOutIfFromIfElseFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(IfStatement visited) {
            IfStatement thenInnerIfStatement = ASTNodes.as(visited.getThenStatement(), IfStatement.class);
            IfStatement elseInnerIfStatement = ASTNodes.as(visited.getElseStatement(), IfStatement.class);
            if (thenInnerIfStatement != null && elseInnerIfStatement != null && thenInnerIfStatement.getElseStatement() == null && elseInnerIfStatement.getElseStatement() == null && ASTNodes.isPassive((ASTNode)visited.getExpression()) && ASTNodes.isPassive((ASTNode)thenInnerIfStatement.getExpression()) && ASTNodes.match((ASTNode)thenInnerIfStatement.getExpression(), (ASTNode)elseInnerIfStatement.getExpression())) {
                this.fResult.add(new PullOutIfFromIfElseOperation(visited, thenInnerIfStatement, elseInnerIfStatement));
                return false;
            }
            return true;
        }
    }

    private static class PullOutIfFromIfElseOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final IfStatement visited;
        private final IfStatement thenInnerIfStatement;
        private final IfStatement elseInnerIfStatement;

        public PullOutIfFromIfElseOperation(IfStatement visited, IfStatement thenInnerIfStatement, IfStatement elseInnerIfStatement) {
            this.visited = visited;
            this.thenInnerIfStatement = thenInnerIfStatement;
            this.elseInnerIfStatement = elseInnerIfStatement;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.PullOutIfFromIfElseCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            Expression newCondition = ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.thenInnerIfStatement.getExpression()));
            IfStatement newIfStatement = ast.newIfStatement();
            newIfStatement.setExpression(newCondition);
            Block newBlock = ast.newBlock();
            newBlock.statements().add(ASTNodes.createMoveTarget(rewrite, this.visited));
            newIfStatement.setThenStatement((Statement)newBlock);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)newIfStatement, group);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited.getThenStatement(), (ASTNode)ASTNodes.createMoveTarget(rewrite, this.thenInnerIfStatement.getThenStatement()), group);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited.getElseStatement(), (ASTNode)ASTNodes.createMoveTarget(rewrite, this.elseInnerIfStatement.getThenStatement()), group);
        }
    }
}

