/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.builders.DefaultSAXParser;
import org.eclipse.pde.internal.core.builders.PDEBuilderHelper;
import org.eclipse.pde.internal.core.builders.UpdateSiteErrorReporter;
import org.eclipse.pde.internal.core.natures.SiteProject;

public class UpdateSiteBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = null;
        if (kind != 6) {
            delta = this.getDelta(this.getProject());
        }
        if (delta == null || kind == 6) {
            IProject project = this.getProject();
            IFile file = project.getFile("site.xml");
            if (file.exists()) {
                this.checkFile(file, monitor);
            }
        } else {
            delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor));
        }
        return null;
    }

    private void checkFile(IFile file, IProgressMonitor monitor) {
        String message = NLS.bind((String)PDECoreMessages.Builders_verifying, (Object)file.getFullPath().toString());
        monitor.subTask(message);
        UpdateSiteErrorReporter reporter = new UpdateSiteErrorReporter(file);
        DefaultSAXParser.parse(file, reporter);
        if (reporter.getErrorCount() == 0) {
            reporter.validateContent(monitor);
        }
        monitor.subTask(PDECoreMessages.Builders_updating);
        monitor.done();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IFile site = this.getProject().getFile("site.xml");
        if (site.exists()) {
            SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)PDECoreMessages.UpdateSiteBuilder_0, (Object)site.getName()), (int)1);
            site.deleteMarkers("org.eclipse.pde.core.problem", true, 0);
            localmonitor.split(1);
        }
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        return new MultiRule((ISchedulingRule[])Arrays.stream(this.getProject().getWorkspace().getRoot().getProjects()).filter(PDEBuilderHelper::isPDEProject).toArray(ISchedulingRule[]::new));
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private final IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) {
            IFile candidate;
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                return SiteProject.isSiteProject(project);
            }
            if (resource instanceof IFile && (candidate = (IFile)resource).getName().equals("site.xml") && delta.getKind() != 2) {
                UpdateSiteBuilder.this.checkFile(candidate, this.monitor);
                return true;
            }
            return true;
        }
    }
}

