/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt.peg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.TeslaScenarioContainer;
import org.eclipse.rcptt.tesla.core.protocol.ElementCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandToElementEntry;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandTransferKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawEvent;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.ITeslaRecordingListener;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.ApplicationResult;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.ProcessingRule;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.CollapseApplyDeactivate;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.CollapseClickText;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.CollapseSelectAfterCellEdit;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.CollapseTraverse;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.DuplicateMouseMoveOverEditPart;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.DuplicateSetCaretPositionStyledText;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.DuplicateSetFocus;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.KeepOnlyLastDragSetData;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.MouseUpSameCellAsMouseDown;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.MouseUpSameTableAsMouseDown;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.QuickAccessIgnoreEmptySetText;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.RemoveMouseMoveAndMousePressBeforeDragStart;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.RemoveMousePressBeforeDragStart;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.SelectAfterMouseDownInTable;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.rules.SetTextAfterSetFocus;
import org.eclipse.rcptt.tesla.recording.core.swt.rap.BasicRecordingHelper;

public class CommandPostProcessor
implements ITeslaRecordingListener {
    private TeslaRecorder recorder;
    private static final List<ProcessingRule> rules = new LinkedList<ProcessingRule>(Arrays.asList(new DuplicateSetCaretPositionStyledText(), new SelectAfterMouseDownInTable(), new MouseUpSameCellAsMouseDown(), new MouseUpSameTableAsMouseDown(), new DuplicateSetFocus(), new RemoveMouseMoveAndMousePressBeforeDragStart(), new RemoveMousePressBeforeDragStart(), new SetTextAfterSetFocus(), new CollapseClickText(), new CollapseTraverse(), new QuickAccessIgnoreEmptySetText(), new DuplicateMouseMoveOverEditPart(), new KeepOnlyLastDragSetData(), new CollapseSelectAfterCellEdit(), new CollapseApplyDeactivate()));

    public CommandPostProcessor(TeslaRecorder recorder) {
        this.recorder = recorder;
    }

    public static void addRule(ProcessingRule rule) {
        rules.add(rule);
    }

    public void recordCommand(Command command, List<Element> elements, CommandTransferKind kind, List<Widget> controls, int index, List<RawEvent> rawEvents) {
        for (ProcessingRule rule : rules) {
            List commands;
            if (!rule.matches(commands = this.recorder.getContainer().getCommands())) continue;
            this.applyResult(rule.apply(commands));
        }
    }

    private void dumpCommands(List<Command> commands) {
        int i = 0;
        while (i < commands.size()) {
            System.out.println(String.valueOf(i) + ":" + commands.get(i).toString());
            ++i;
        }
    }

    protected void checkIntegrity() {
        List commands = this.recorder.getContainer().getCommands();
        EList mappings = this.recorder.getContainer().getScenario().getElementMapping();
        HashSet<String> knownElements = new HashSet<String>();
        for (CommandToElementEntry entry : mappings) {
            knownElements.add(((Element)entry.getElements().get(0)).getId());
        }
        for (Command cmd : commands) {
            Element element;
            Element element2 = element = cmd instanceof ElementCommand ? ((ElementCommand)cmd).getElement() : ((SelectCommand)cmd).getData().getParent();
            if (element == null || knownElements.contains(element.getId())) continue;
            System.out.println("Unknown element " + element.getId());
        }
    }

    private void applyResult(ApplicationResult result) {
        Map<SelectCommand, Element> droppedElements = CommandPostProcessor.getElementsBySelect(this.recorder.getContainer(), result.drop);
        int i = 0;
        while (i < result.drop) {
            this.recorder.removeLast();
            ++i;
        }
        int[] nArray = result.remove;
        int n = result.remove.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            this.recorder.remove(i);
            ++n2;
        }
        HashMap<String, String> elementSubstitutions = new HashMap<String, String>();
        Command[] commandArray = result.add;
        int n3 = result.add.length;
        n = 0;
        while (n < n3) {
            Command cmd = commandArray[n];
            if (cmd instanceof SelectCommand) {
                this.executeSelectCommand((SelectCommand)cmd, droppedElements, elementSubstitutions);
            } else if (cmd instanceof ElementCommand) {
                this.executeElementCommand((ElementCommand)cmd, elementSubstitutions);
            } else {
                this.recorder.executeCommand(cmd);
            }
            ++n;
        }
        this.removeElementsFromMappers(droppedElements.values());
        this.checkIntegrity();
    }

    private void executeElementCommand(ElementCommand cmd, Map<String, String> substitutions) {
        String substitution = substitutions.get(cmd.getElement().getId());
        if (substitution != null) {
            cmd.getElement().setId(substitution);
        }
        this.recorder.executeCommand((Command)EcoreUtil.copy((EObject)cmd));
    }

    private void executeSelectCommand(SelectCommand cmd, Map<SelectCommand, Element> droppedElements, Map<String, String> mapping) {
        SelectCommand copy = (SelectCommand)EcoreUtil.copy((EObject)cmd);
        Element parent = cmd.getData().getParent();
        if (parent != null && mapping.containsKey(parent.getId())) {
            parent.setId(mapping.get(parent.getId()));
        }
        EList elements = ((SelectResponse)this.recorder.executeCommand((Command)copy)).getElements();
        if (!droppedElements.containsKey(cmd) || elements.size() != 1) {
            return;
        }
        Element old = droppedElements.get(cmd);
        Element updated = (Element)elements.get(0);
        mapping.put(old.getId(), updated.getId());
        this.updateElementMappers(old, updated);
        droppedElements.remove(cmd);
    }

    private List<BasicRecordingHelper<Object>> getAllHelpers() {
        ArrayList<BasicRecordingHelper<Object>> result = new ArrayList<BasicRecordingHelper<Object>>();
        for (IRecordingProcessor processor : this.recorder.getProcessors(IRecordingProcessor.class)) {
            IRecordingHelper helper = processor.getHelper();
            if (!(helper instanceof BasicRecordingHelper)) continue;
            result.add((BasicRecordingHelper)helper);
        }
        return result;
    }

    private void removeElementsFromMappers(Collection<Element> elements) {
        for (BasicRecordingHelper<Object> rh : this.getAllHelpers()) {
            for (Element element : elements) {
                Object key = rh.findByElement(element);
                if (key == null) continue;
                rh.remove(key);
            }
        }
    }

    private void updateElementMappers(Element old, Element updated) {
        for (BasicRecordingHelper<Object> rh : this.getAllHelpers()) {
            Object key = rh.findByElement(old);
            if (key == null) continue;
            rh.get(key).getElement().setId(updated.getId());
        }
    }

    private static Map<SelectCommand, Element> getElementsBySelect(TeslaScenarioContainer container, int drop) {
        HashMap<SelectCommand, Element> result = new HashMap<SelectCommand, Element>();
        for (SelectCommand cmd : CommandPostProcessor.getSelectCommands(container.getCommands(), drop)) {
            Element element = CommandPostProcessor.getSelectElement(container, cmd);
            if (element == null) continue;
            result.put(cmd, element);
        }
        return result;
    }

    private static Element getSelectElement(TeslaScenarioContainer container, SelectCommand command) {
        for (CommandToElementEntry entry : container.getScenario().getElementMapping()) {
            if (!EcoreUtil.equals((EObject)entry.getCommand(), (EObject)command) || entry.getElements().size() <= 0) continue;
            return (Element)entry.getElements().get(0);
        }
        return null;
    }

    private static List<SelectCommand> getSelectCommands(List<Command> commands, int drop) {
        int length = commands.size();
        ArrayList<SelectCommand> result = new ArrayList<SelectCommand>();
        int i = length - drop;
        while (i < length) {
            Command cmd = commands.get(i);
            if (cmd instanceof SelectCommand) {
                result.add((SelectCommand)cmd);
            }
            ++i;
        }
        return result;
    }
}

