/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.runtime.ui.rap;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.ecl.core.model.Q7Information;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.core.am.rap.AspectManager;
import org.eclipse.rcptt.tesla.core.server.TeslaServerManager;
import org.eclipse.rcptt.tesla.ui.RWTUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;

public class GetQ7InformationService
implements ICommandService {
    private static final int TIMEOUT = 1000;

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        IWorkbench workbench;
        IPipe output = context.getOutput();
        final Q7Information info = Q7CoreFactory.eINSTANCE.createQ7Information();
        info.setVersion(((String)Platform.getBundle((String)"org.eclipse.rcptt.core").getHeaders().get("Bundle-Version")).toString());
        IStatus result = AspectManager.initialize();
        info.setTeslaActive(result.isOK() && TeslaServerManager.getServer() != null);
        if (info.isTeslaActive()) {
            info.setTeslaPort(TeslaServerManager.getServer().getPort());
        }
        if ((workbench = RWTUtils.getWorkbench()) != null && !workbench.isClosing()) {
            Display display;
            info.setWindowCount(workbench.getWorkbenchWindowCount());
            if (info.getWindowCount() == 0 && (display = RWTUtils.findDisplay()) != null) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        info.setWindowCount(workbench.getWorkbenchWindowCount());
                        if (info.getWindowCount() == 0 && workbench.getActiveWorkbenchWindow() != null) {
                            info.setWindowCount(1);
                        }
                    }
                });
            }
        } else if (RWTUtils.findDisplay() != null) {
            info.setWindowCount(1);
        }
        this.checkActiveClient(info);
        output.write((Object)info);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkActiveClient(final Q7Information info) {
        Display display = RWTUtils.findDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                info.setClientActive(true);
                Q7Information q7Information = info;
                synchronized (q7Information) {
                    info.notifyAll();
                }
            }
        });
        Q7Information q7Information = info;
        synchronized (q7Information) {
            try {
                info.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

