/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.IRFSRegistry;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.RFSRegistryFactory;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.core.utils.ResourceUtils;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedFile;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.team.core.history.IFileRevision;

public class R4EUIPostponedContainer
extends R4EUIFileContainer {
    public static final String POSTPONED_CONTAINER_ICON_FILE = "icons/obj16/postcont_obj.gif";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Postponed Elements";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable the Postponed Elements from their Parent Review";
    protected R4EUIPostponedAnomalyContainer fAnomalyContainer = new R4EUIPostponedAnomalyContainer(this, "Global Postponed Anomalies");

    public R4EUIPostponedContainer(IR4EUIModelElement aParent, R4EItem aItem, String aName) {
        super(aParent, aItem, aName, 2);
    }

    public String getImageLocation() {
        return POSTPONED_CONTAINER_ICON_FILE;
    }

    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        return null;
    }

    public R4EUIPostponedAnomalyContainer getAnomalyContainer() {
        return this.fAnomalyContainer;
    }

    public IR4EUIModelElement[] getChildren() {
        ArrayList<R4EUIModelElement> newList = new ArrayList<R4EUIModelElement>();
        for (R4EUIFileContext file : this.fFileContexts) {
            if (file.getChildren().length <= 0) continue;
            newList.add(file);
        }
        if (this.fAnomalyContainer.getChildren().length > 0) {
            newList.add(this.fAnomalyContainer);
        }
        return newList.toArray(new IR4EUIModelElement[newList.size()]);
    }

    public void open() {
        EList files = this.fItem.getFileContextList();
        if (files != null) {
            R4EUIPostponedFile uiFile = null;
            int filesSize = files.size();
            int i = 0;
            while (i < filesSize) {
                uiFile = new R4EUIPostponedFile((IR4EUIModelElement)this, (R4EFileContext)files.get(i));
                this.addChildren(uiFile);
                uiFile.open();
                ++i;
            }
        }
        if (R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("importPostponedGlobalAnomaliesPreferences")) {
            this.fAnomalyContainer.setReadOnly(this.fReadOnly);
            this.fAnomalyContainer.open();
        }
        this.fOpen = true;
    }

    public void close() {
        R4EUIFileContext fileContext = null;
        int fileContextsSize = this.fFileContexts.size();
        int i = 0;
        while (i < fileContextsSize) {
            fileContext = (R4EUIFileContext)this.fFileContexts.get(i);
            fileContext.close();
            ++i;
        }
        this.fFileContexts.clear();
        this.fAnomalyContainer.close();
        this.fOpen = false;
    }

    public boolean hasChildren() {
        return this.fFileContexts.size() > 0 || this.fAnomalyContainer.getChildren().length > 0;
    }

    public void addChildren(IR4EUIModelElement aChildToAdd) {
        if (aChildToAdd instanceof R4EUIFileContext) {
            this.fFileContexts.add((R4EUIFileContext)aChildToAdd);
        } else if (aChildToAdd instanceof R4EUIPostponedAnomalyContainer) {
            this.fAnomalyContainer = (R4EUIPostponedAnomalyContainer)aChildToAdd;
        }
    }

    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        if (aChildToRemove instanceof R4EUIPostponedFile) {
            R4EUIFileContext removedElement = (R4EUIFileContext)this.fFileContexts.get(this.fFileContexts.indexOf(aChildToRemove));
            removedElement.removeAllChildren(aFileRemove);
            R4EFileContext modelFile = removedElement.getFileContext();
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelFile, R4EUIModelController.getReviewer());
            modelFile.setEnabled(false);
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
            if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                this.fFileContexts.remove(removedElement);
            }
        } else if (aChildToRemove instanceof R4EUIAnomalyContainer) {
            this.fAnomalyContainer.removeAllChildren(aFileRemove);
        }
    }

    public R4EUIPostponedFile createFileContext(R4EFileVersion aTargetTempFileVersion) throws ResourceHandlingException, OutOfSyncException {
        IRFSRegistry revRegistry = null;
        try {
            revRegistry = RFSRegistryFactory.getRegistry((R4EReview)((R4EUIReviewBasic)this.getParent()).getReview());
        }
        catch (ReviewsFileStorageException e1) {
            R4EUIPlugin.Ftracer.traceInfo("Exception: " + e1.toString() + " (" + e1.getMessage() + ")");
        }
        R4EFileContext fileContext = R4EUIModelController.FModelExt.createR4EFileContext(this.fItem);
        if (aTargetTempFileVersion != null) {
            R4EFileVersion rfileTargetVersion = R4EUIModelController.FModelExt.createR4ETargetFileVersion(fileContext);
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)rfileTargetVersion, R4EUIModelController.getReviewer());
            CommandUtils.copyFileVersionData(rfileTargetVersion, aTargetTempFileVersion);
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
            try {
                IFile targetFile = ResourceUtils.toIFile((String)rfileTargetVersion.getPlatformURI());
                rfileTargetVersion.setResource((IResource)targetFile);
            }
            catch (FileNotFoundException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                rfileTargetVersion.setResource(null);
            }
            if (revRegistry != null) {
                try {
                    IFileRevision fileRev = revRegistry.getIFileRevision(null, rfileTargetVersion);
                    rfileTargetVersion.setFileRevision(fileRev);
                }
                catch (ReviewsFileStorageException e) {
                    R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }
        }
        R4EUIPostponedFile uiFile = new R4EUIPostponedFile((IR4EUIModelElement)this, fileContext);
        this.addChildren(uiFile);
        return uiFile;
    }

    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    public boolean isChangeUserReviewStateCmd() {
        return false;
    }

    public boolean isSendEmailCmd() {
        return false;
    }
}

