/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.acquire.GrantAcquisition;
import org.eclipse.passage.lic.api.acquire.LicenseAcquisitionService;
import org.eclipse.passage.lic.api.acquire.LicenseAcquisitionServicesRegistry;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.internal.base.access.storage.GrantReleased;

final class Conduit {
    private final Supplier<LicensedProduct> product;
    private final Supplier<LicenseAcquisitionServicesRegistry> acquirers;

    Conduit(Supplier<LicensedProduct> product, Supplier<LicenseAcquisitionServicesRegistry> acquirers) {
        this.product = product;
        this.acquirers = acquirers;
    }

    List<GrantAcquisition> release(List<GrantAcquisition> grants) {
        ArrayList<GrantAcquisition> released = new ArrayList<GrantAcquisition>();
        for (GrantAcquisition grant : grants) {
            if (!this.release(grant)) continue;
            released.add(grant);
        }
        return released;
    }

    private boolean release(GrantAcquisition grant) {
        LicensedProduct licproduct = this.product.get();
        for (LicenseAcquisitionService service : ((Registry)this.acquirers.get().get()).services()) {
            ServiceInvocationResult result = service.release(licproduct, grant);
            if (!new GrantReleased().test((ServiceInvocationResult<Boolean>)result)) continue;
            return true;
        }
        return false;
    }
}

