/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.requirements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.base.KeyValuePairs;
import org.eclipse.passage.lic.internal.equinox.requirements.LicCapabilityNamespace;

final class LicCapabilityAttributesFromDeclaration {
    private final String declarations;

    public LicCapabilityAttributesFromDeclaration(String declarations) {
        Objects.requireNonNull(declarations, "LicCapabilityAttributesFromDeclaration::declarations");
        this.declarations = declarations;
    }

    public Collection<Map<String, Object>> get() throws LicensingException {
        String namespace = new LicCapabilityNamespace().get();
        List sources = Arrays.stream(this.declarations.split(",")).map(String::trim).filter(source -> source.startsWith(namespace)).map(source -> source.substring(namespace.length())).collect(Collectors.toList());
        ArrayList<Map<String, Object>> structured = new ArrayList<Map<String, Object>>();
        for (String source2 : sources) {
            structured.add(this.attributes(source2));
        }
        return structured;
    }

    private Map<String, Object> attributes(String source) throws LicensingException {
        Properties properties = new KeyValuePairs(this.lined(source), "Failed to compose licensing requirement declaration").get();
        return properties.keySet().stream().map(String.class::cast).filter(key -> !properties.getProperty((String)key).trim().isEmpty()).collect(Collectors.toMap(Function.identity(), key -> this.unquote(properties.getProperty((String)key).trim())));
    }

    private String lined(String source) {
        return source.replaceAll(";", "\n");
    }

    private String unquote(String value) {
        String unquoted = value;
        if (unquoted.startsWith("\"")) {
            unquoted = unquoted.substring(1);
        }
        if (unquoted.endsWith("\"")) {
            unquoted = unquoted.substring(0, unquoted.length() - 1);
        }
        return unquoted;
    }
}

