/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.passage.lic.internal.base.ProductVersion;
import org.eclipse.passage.lic.internal.base.version.BaseSemanticVersion;
import org.eclipse.passage.lic.internal.base.version.DefaultVersion;
import org.eclipse.passage.lic.internal.base.version.SafeVersion;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class ApplicationVersion
implements Supplier<String> {
    private final IApplicationContext context;

    public ApplicationVersion(IApplicationContext context) {
        this.context = context;
    }

    @Override
    public String get() {
        Optional property = new ProductVersion(arg_0 -> ((IApplicationContext)this.context).getBrandingProperty(arg_0)).get();
        if (property.isPresent()) {
            return new SafeVersion(property.get()).semantic().toString();
        }
        return Optional.ofNullable(this.context.getBrandingBundle()).map(Bundle::getVersion).map(this::stringify).orElse(new DefaultVersion().toString());
    }

    private String stringify(Version version) {
        return new BaseSemanticVersion(version.getMajor(), version.getMinor(), version.getMicro()).toString();
    }
}

