/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions.evaluation;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.EvaluationType;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriod;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriodClosed;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Emission;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionEvaluationException;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionEvaluationService;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionEvaluatorsRegistry;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionParsingException;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionParsingService;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionPasringRegistry;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionProtocol;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionTokenAssessmentService;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionTokenAssessorsRegistry;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ParsedExpression;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.PermissionEmittingService;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.SumOfCollections;
import org.eclipse.passage.lic.internal.base.conditions.evaluation.BasePermission;
import org.eclipse.passage.lic.internal.base.conditions.evaluation.FormalizedExpression;
import org.eclipse.passage.lic.internal.base.conditions.evaluation.SumOfEmissions;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.code.LicenseDoesNotMatch;
import org.eclipse.passage.lic.internal.base.diagnostic.code.LicenseInvalid;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.internal.base.i18n.ConditionsEvaluationMessages;

public final class BasePermissionEmittingService
implements PermissionEmittingService {
    private final StringServiceId id = new StringServiceId("default-emitter");
    private final ExpressionPasringRegistry parsers;
    private final ExpressionTokenAssessorsRegistry assessors;
    private final ExpressionEvaluatorsRegistry evaluators;

    public BasePermissionEmittingService(ExpressionPasringRegistry parsers, ExpressionTokenAssessorsRegistry assessors, ExpressionEvaluatorsRegistry evaluators) {
        Objects.requireNonNull(parsers);
        Objects.requireNonNull(assessors);
        Objects.requireNonNull(evaluators);
        this.assessors = assessors;
        this.parsers = parsers;
        this.evaluators = evaluators;
    }

    public StringServiceId id() {
        return this.id;
    }

    public ServiceInvocationResult<Collection<Emission>> emit(Collection<ConditionPack> conditions, LicensedProduct product) {
        return conditions.stream().map(pack -> this.emitFor((ConditionPack)pack, product)).reduce(new BaseServiceInvocationResult.Sum(new SumOfCollections())).orElse(new BaseServiceInvocationResult(new ArrayList()));
    }

    private ServiceInvocationResult<Collection<Emission>> emitFor(ConditionPack pack, LicensedProduct product) {
        return pack.conditions().stream().map(condition -> this.emitFor((Condition)condition, pack, product)).reduce(new BaseServiceInvocationResult.Sum<Emission>(new SumOfEmissions())).map(this::singleton).orElse(new BaseServiceInvocationResult(Collections.emptyList()));
    }

    private ServiceInvocationResult<Collection<Emission>> singleton(ServiceInvocationResult<Emission> origin) {
        return new BaseServiceInvocationResult<Collection<Emission>>(origin.diagnostic(), origin.data().isPresent() ? Collections.singleton((Emission)origin.data().get()) : Collections.emptyList());
    }

    private ServiceInvocationResult<Emission> emitFor(Condition condition, ConditionPack pack, LicensedProduct product) {
        try {
            this.expressionIsSatisfied(condition);
        }
        catch (ExpressionParsingException e) {
            return this.fail(pack, new LicenseInvalid(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.parse_failed"), condition.evaluationInstructions().expression()), (Exception)((Object)e));
        }
        catch (ExpressionEvaluationException e) {
            return this.fail(pack, new LicenseDoesNotMatch(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.evaluation_failed"), condition.evaluationInstructions().expression()), (Exception)((Object)e));
        }
        catch (LicensingException e) {
            return this.fail(pack, new LicenseInvalid(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.assessment_failed"), condition.evaluationInstructions().expression()), (Exception)((Object)e));
        }
        return this.createFor(condition, pack, product);
    }

    private ServiceInvocationResult<Emission> createFor(Condition condition, ConditionPack pack, LicensedProduct product) {
        try {
            return new BaseServiceInvocationResult<Emission>(new Emission(pack, (Permission)new BasePermission(product, condition, ZonedDateTime.now(), this.expiration(condition.validityPeriod()))));
        }
        catch (Exception e) {
            return new BaseServiceInvocationResult<Emission>(new BaseDiagnostic(Collections.singletonList(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.failed_create_permission"), condition.feature(), condition.identifier()), e))));
        }
    }

    private ServiceInvocationResult<Emission> fail(ConditionPack pack, TroubleCode code, String explanation, Exception e) {
        return new BaseServiceInvocationResult<Emission>((Diagnostic)new BaseDiagnostic(Collections.singletonList(new Trouble(code, explanation, e))), new Emission(pack));
    }

    private void expressionIsSatisfied(Condition condition) throws ExpressionParsingException, ExpressionEvaluationException, LicensingException {
        ExpressionTokenAssessmentService assessor = this.assessor(condition.evaluationInstructions().type());
        ParsedExpression expression = new FormalizedExpression(condition.evaluationInstructions().expression(), (Registry<ExpressionProtocol, ExpressionParsingService>)((Registry)this.parsers.get())).get();
        ExpressionEvaluationService evaluator = (ExpressionEvaluationService)((Registry)this.evaluators.get()).service((ServiceId)expression.protocol());
        evaluator.evaluate(expression, assessor);
    }

    private ExpressionTokenAssessmentService assessor(EvaluationType type) throws LicensingException {
        if (!((Registry)this.assessors.get()).hasService((ServiceId)type)) {
            throw new LicensingException(String.format(ConditionsEvaluationMessages.getString("BasePermissionEmittingService.no_assessment_service"), type));
        }
        return (ExpressionTokenAssessmentService)((Registry)this.assessors.get()).service((ServiceId)type);
    }

    private ZonedDateTime expiration(ValidityPeriod period) {
        if (ValidityPeriodClosed.class.isInstance(period)) {
            return ((ValidityPeriodClosed)period).to();
        }
        return ZonedDateTime.now().plusDays(1L);
    }
}

