/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StyledString
implements Iterable<Fragment> {
    private final List<Fragment> content = new ArrayList<Fragment>();

    public StyledString() {
    }

    public StyledString(String text) {
        this(text, Style.NO_STYLE);
    }

    public StyledString(String text, Style style) {
        this.append(text, style);
    }

    public String getString() {
        StringBuilder result = new StringBuilder();
        for (Fragment styledString : this) {
            result.append(styledString.getString());
        }
        return result.toString();
    }

    public StyledString append(String string) {
        this.content.add(new Fragment(string, Style.NO_STYLE));
        return this;
    }

    public StyledString append(String string, Style style) {
        this.content.add(new Fragment(string, style));
        return this;
    }

    public StyledString append(StyledString styledString) {
        this.content.addAll(styledString.content);
        return this;
    }

    @Override
    public Iterator<Fragment> iterator() {
        return this.content.iterator();
    }

    public static final class Fragment {
        private final String string;
        private final Style style;

        private Fragment(String string, Style style) {
            this.string = string;
            this.style = style;
        }

        public String getString() {
            return this.string;
        }

        public Style getStyle() {
            return this.style;
        }
    }

    public static final class Style {
        public static final Style NO_STYLE = new Style(null, null, null, false, null, null, null, null, null, "NO_STYLE");
        public static final Style QUALIFIER_STYLER = new Style(null, null, null, false, null, null, null, null, null, "QUALIFIER_STYLER");
        public static final Style COUNTER_STYLER = new Style(null, null, null, false, null, null, null, null, null, "COUNTER_STYLER");
        public static final Style DECORATIONS_STYLER = new Style(null, null, null, false, null, null, null, null, null, "DECORATIONS_STYLER");
        private final URI font;
        private final URI backgroundColor;
        private final URI foregroundColor;
        private final boolean isStrikedout;
        private final URI strikeoutColor;
        private final UnderLineStyle underlineStyle;
        private final URI underlineColor;
        private final BorderStyle borderStyle;
        private final URI borderColor;
        private String toString;

        private Style(URI font, URI backgroundColor, URI foregroundColor, boolean isStrikedout, URI strikeoutColor, UnderLineStyle underlineStyle, URI underlineColor, BorderStyle borderStyle, URI borderColor, String toString) {
            this(font, backgroundColor, foregroundColor, isStrikedout, strikeoutColor, underlineStyle, underlineColor, borderStyle, borderColor);
            this.toString = toString;
        }

        private Style(URI font, URI backgroundColor, URI foregroundColor, boolean isStrikedout, URI strikeoutColor, UnderLineStyle underlineStyle, URI underlineColor, BorderStyle borderStyle, URI borderColor) {
            this.font = font;
            this.backgroundColor = backgroundColor;
            this.foregroundColor = foregroundColor;
            this.isStrikedout = isStrikedout;
            this.strikeoutColor = strikeoutColor;
            this.underlineStyle = underlineStyle;
            this.underlineColor = underlineColor;
            this.borderStyle = borderStyle;
            this.borderColor = borderColor;
        }

        public URI getFont() {
            return this.font;
        }

        public URI getBackgoundColor() {
            return this.backgroundColor;
        }

        public URI getForegroundColor() {
            return this.foregroundColor;
        }

        public boolean isStrikedout() {
            return this.isStrikedout;
        }

        public URI getStrikeoutColor() {
            return this.strikeoutColor;
        }

        public UnderLineStyle getUnderlineStyle() {
            return this.underlineStyle;
        }

        public URI getUnderlineColor() {
            return this.underlineColor;
        }

        public BorderStyle getBorderStyle() {
            return this.borderStyle;
        }

        public URI getBorderColor() {
            return this.borderColor;
        }

        public String toString() {
            if (this.toString == null) {
                StringBuilder sb = new StringBuilder(Style.class.getSimpleName()).append('(');
                sb.append("font: ").append(this.font);
                sb.append(", backgroundColor: ").append(this.backgroundColor);
                sb.append(", foregroundColor: ").append(this.foregroundColor);
                if (this.isStrikedout) {
                    sb.append(", strikedout(color: ").append(this.strikeoutColor).append(')');
                }
                if (this.underlineStyle != UnderLineStyle.NONE) {
                    sb.append(", underlined(style: ").append((Object)this.underlineStyle).append(", color: ").append(this.underlineColor).append(')');
                }
                if (this.borderStyle != BorderStyle.NONE) {
                    sb.append(", border(style: ").append((Object)this.borderStyle).append(", color: ").append(this.borderColor).append(')');
                }
                this.toString = sb.append(')').toString();
            }
            return this.toString;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum BorderStyle {
            NONE,
            SOLID,
            DOT,
            DASH;

        }

        public static final class Builder {
            private static final URI BLACK = URI.createURI((String)"color://rgb/0/0/0");
            private URI font;
            private URI backgroundColor;
            private URI foregroundColor;
            private boolean isStrikedout;
            private URI strikeoutColor;
            private UnderLineStyle underlineStyle = UnderLineStyle.NONE;
            private URI underlineColor;
            private BorderStyle borderStyle = BorderStyle.NONE;
            private URI borderColor;

            private Builder() {
            }

            public Builder setFont(URI font) {
                this.font = font;
                return this;
            }

            public Builder setBackgroundColor(URI backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Builder setForegroundColor(URI foregroundColor) {
                this.foregroundColor = foregroundColor;
                return this;
            }

            public Builder setStrikedout(boolean isStrikedout) {
                this.isStrikedout = isStrikedout;
                if (this.strikeoutColor == null) {
                    this.strikeoutColor = BLACK;
                }
                return this;
            }

            public Builder setStrikeoutColor(URI strikeoutColor) {
                this.strikeoutColor = strikeoutColor;
                this.isStrikedout = true;
                return this;
            }

            public Builder setBorderColor(URI borderColor) {
                this.borderColor = borderColor;
                if (this.borderStyle == BorderStyle.NONE) {
                    this.borderStyle = BorderStyle.SOLID;
                }
                return this;
            }

            public Builder setBorderStyle(BorderStyle borderStyle) {
                this.borderStyle = borderStyle;
                if (this.borderColor == null) {
                    this.borderColor = BLACK;
                }
                return this;
            }

            public Builder setUnderlineColor(URI underlineColor) {
                this.underlineColor = underlineColor;
                if (this.underlineStyle == UnderLineStyle.NONE) {
                    this.underlineStyle = UnderLineStyle.SINGLE;
                }
                return this;
            }

            public Builder setUnderlineStyle(UnderLineStyle underlineStyle) {
                this.underlineStyle = underlineStyle;
                if (this.underlineColor == null) {
                    this.underlineColor = BLACK;
                }
                return this;
            }

            public Style toStyle() {
                return new Style(this.font, this.backgroundColor, this.foregroundColor, this.isStrikedout, this.strikeoutColor, this.underlineStyle, this.underlineColor, this.borderStyle, this.borderColor);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum UnderLineStyle {
            NONE,
            SINGLE,
            DOUBLE,
            SQUIGGLE,
            ERROR,
            LINK;

        }
    }
}

