/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sat4j.core.ASolverFactory;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckMUSSolutionListener
implements SolutionFoundListener {
    private List<IVecInt> clauses = new ArrayList<IVecInt>();
    private String explain;
    private final ASolverFactory<? extends ISolver> factory;

    public CheckMUSSolutionListener(ASolverFactory<? extends ISolver> factory) {
        this.factory = factory;
    }

    public void addOriginalClause(IVecInt clause) {
        VecInt newClause = new VecInt(clause.size());
        if (this.clauses == null) {
            this.clauses = new ArrayList<IVecInt>();
        }
        clause.copyTo(newClause);
        this.clauses.add(newClause);
    }

    public boolean checkThatItIsAMUS(IVecInt mus) {
        boolean result = false;
        ISolver solver = this.factory.defaultSolver();
        try {
            int i = 0;
            while (i < mus.size()) {
                solver.addClause(this.clauses.get(mus.get(i) - 1));
                ++i;
            }
            boolean bl = result = !solver.isSatisfiable();
            if (!result) {
                this.explain = "The set of clauses in the MUS is SAT : " + Arrays.toString(solver.model());
                return result;
            }
        }
        catch (ContradictionException contradictionException) {
            result = true;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        try {
            int i = 0;
            while (i < mus.size()) {
                solver = this.factory.defaultSolver();
                int j = 0;
                while (j < mus.size()) {
                    if (j != i) {
                        solver.addClause(this.clauses.get(mus.get(j) - 1));
                    }
                    ++j;
                }
                boolean bl = result = result && solver.isSatisfiable();
                if (!result) {
                    this.explain = "The subset of clauses in the MUS not containing clause " + (i + 1) + " is SAT : " + Arrays.toString(solver.model());
                    return result;
                }
                ++i;
            }
        }
        catch (ContradictionException contradictionException) {
            result = false;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void onSolutionFound(int[] solution) {
    }

    @Override
    public void onSolutionFound(IVecInt solution) {
        if (this.checkThatItIsAMUS(solution)) {
            System.out.println(solution + " is a MUS");
        } else {
            System.out.println(solution + " is not a MUS \n" + this.explain);
        }
    }

    @Override
    public void onUnsatTermination() {
    }
}

