/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.api.io;

import java.util.Objects;

public abstract class EncryptionAlgorithm {
    private final String name;

    public EncryptionAlgorithm(String name) {
        Objects.requireNonNull(name, "EncryptionAlgorithm::name");
        this.name = name.toUpperCase();
    }

    public final String name() {
        return this.name;
    }

    public final boolean equals(Object object) {
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        return this.name.equals(((EncryptionAlgorithm)object).name());
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final String toString() {
        return this.name;
    }

    public static final class Default
    extends EncryptionAlgorithm {
        public Default() {
            super(new RSA().name());
        }
    }

    public static final class Of
    extends EncryptionAlgorithm {
        public Of(String name) {
            super(name);
        }
    }

    public static final class RSA
    extends EncryptionAlgorithm {
        public RSA() {
            super("RSA");
        }
    }
}

