/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.mining.MinedConditions;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.SumOfCollections;
import org.eclipse.passage.lic.internal.base.conditions.ConditionsFeatureFilter;
import org.eclipse.passage.lic.internal.base.diagnostic.code.NoServicesOfType;
import org.eclipse.passage.lic.internal.base.i18n.AccessCycleMessages;

public final class Conditions
implements Supplier<ServiceInvocationResult<Collection<ConditionPack>>> {
    private final Registry<StringServiceId, MinedConditions> registry;
    private final LicensedProduct product;
    private final Function<ServiceInvocationResult<Collection<ConditionPack>>, ServiceInvocationResult<Collection<ConditionPack>>> filter;

    public Conditions(Registry<StringServiceId, MinedConditions> registry, LicensedProduct product, String feature) {
        this(registry, product, (Function<ServiceInvocationResult<Collection<ConditionPack>>, ServiceInvocationResult<Collection<ConditionPack>>>)new ConditionsFeatureFilter(feature).get());
    }

    public Conditions(Registry<StringServiceId, MinedConditions> registry, LicensedProduct product) {
        this(registry, product, Function.identity());
    }

    public Conditions(Registry<StringServiceId, MinedConditions> registry, LicensedProduct product, Function<ServiceInvocationResult<Collection<ConditionPack>>, ServiceInvocationResult<Collection<ConditionPack>>> filter) {
        Objects.requireNonNull(registry, "Conditions::registry");
        Objects.requireNonNull(product, "Conditions::product");
        Objects.requireNonNull(product, "Conditions::product");
        this.registry = registry;
        this.product = product;
        this.filter = filter;
    }

    @Override
    public ServiceInvocationResult<Collection<ConditionPack>> get() {
        if (this.registry.services().isEmpty()) {
            return new BaseServiceInvocationResult<Trouble>(new Trouble((TroubleCode)new NoServicesOfType(AccessCycleMessages.getString("Conditions.servive_type")), AccessCycleMessages.getString("Conditions.no_miners")));
        }
        return this.registry.services().stream().map(miner -> miner.all(this.product)).reduce(new BaseServiceInvocationResult.Sum(new SumOfCollections())).map(this.filter).orElse(new BaseServiceInvocationResult(Collections.emptyList()));
    }
}

