/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.passage.lbc.internal.api.persistence.BoundLicense;
import org.eclipse.passage.lbc.internal.api.persistence.PersistableLicense;
import org.eclipse.passage.lbc.internal.base.persistence.LockFile;
import org.eclipse.passage.lbc.internal.base.persistence.LockFolder;
import org.eclipse.passage.lbc.json.JsonPersistableLicense;
import org.eclipse.passage.lbc.json.LbcJsonObjectMapper;
import org.eclipse.passage.lic.internal.api.conditions.Condition;

public final class JsonLoadedLicense
implements Function<Condition, Optional<PersistableLicense>> {
    private final LockFolder base;

    public JsonLoadedLicense(LockFolder base) {
        Objects.requireNonNull(base, "JsonLoadedPersistableLicense::base");
        this.base = base;
    }

    @Override
    public Optional<PersistableLicense> apply(Condition condition) {
        try {
            ObjectMapper mapper = new LbcJsonObjectMapper().get();
            String raw = Files.readString(new LockFile((Supplier)this.base, condition).get(), StandardCharsets.UTF_8);
            JsonPersistableLicense license = new JsonPersistableLicense((BoundLicense)mapper.readValue(raw, BoundLicense.class), this.base);
            return Optional.of(license);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

