/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.api.conditions.mining;

import java.util.Objects;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;

public abstract class ContentType
implements ServiceId {
    private final String type;

    public ContentType(String type) {
        Objects.requireNonNull(type, "ContentType::type");
        this.type = type;
    }

    public boolean equals(Object object) {
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        return this.type.equals(((ContentType)object).contentType());
    }

    public String contentType() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return this.type;
    }

    public static final class Json
    extends ContentType {
        public Json() {
            super("application/json");
        }
    }

    public static final class Of
    extends ContentType {
        public Of(String type) {
            super(type.toLowerCase());
        }
    }

    public static final class Xml
    extends ContentType {
        public Xml() {
            super("application/xml");
        }
    }
}

