/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.api.conditions;

import java.util.Objects;
import org.eclipse.passage.lic.internal.api.conditions.ConditionAction;

public abstract class UserRole {
    private final String role;

    protected UserRole(String role) {
        Objects.requireNonNull(role, "UserRole::role");
        this.role = role;
    }

    public boolean equals(Object obj) {
        if (!ConditionAction.class.isInstance(obj)) {
            return false;
        }
        return this.role.equals(((ConditionAction)obj).name());
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public final String name() {
        return this.role;
    }

    public String toString() {
        return this.role;
    }

    public static final class Admin
    extends UserRole {
        public Admin() {
            super("admin");
        }
    }

    public static final class Licensee
    extends UserRole {
        public Licensee() {
            super("licensee");
        }
    }

    public static final class Of
    extends UserRole {
        public Of(String role) {
            super(role);
        }
    }

    public static final class Operator
    extends UserRole {
        public Operator() {
            super("operator");
        }
    }
}

