/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.permission;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.eclipse.passage.lic.api.access.FeaturePermission;
import org.eclipse.passage.lic.internal.base.permission.LimitedPermission;
import org.eclipse.passage.lic.internal.base.permission.PermissionObservatory;
import org.eclipse.passage.lic.internal.base.permission.observatory.CheckSchedule;
import org.eclipse.passage.lic.internal.base.permission.observatory.Observatory;

public final class BasePermissionObservatory
implements PermissionObservatory {
    private final Observatory<LimitedPermission> observatory;

    public BasePermissionObservatory(CheckSchedule schedule, Consumer<Set<LimitedPermission>> farewell) {
        this.observatory = new Observatory(schedule, farewell);
    }

    public void watch(Iterable<FeaturePermission> permissions) {
        this.onEachPermission(permissions, this.observatory::watch);
    }

    public void forget(Iterable<FeaturePermission> permissions) {
        this.onEachPermission(permissions, this.observatory::forget);
    }

    public void open() {
        this.observatory.open();
    }

    private void onEachPermission(Iterable<FeaturePermission> permissions, Consumer<LimitedPermission> action) {
        StreamSupport.stream(permissions.spliterator(), false).map(LimitedPermission::new).forEach(action::accept);
    }
}

