/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.net;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public class LicensingRequests {
    public static final String PRODUCT = "product";
    public static final String VERSION = "version";
    public static final String USER = "user";
    public static final String ACTION = "action";
    public static final String MODE = "mode";
    public static final String HANDLER = "handler";
    public static final String PROTOCOL_TYPE_ID = "http";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String CONTENT_TYPE = "content.type";
    private static Logger logger = Logger.getLogger(LicensingRequests.class.getName());

    public static Map<String, String> initRequestParams(String host, String port, String modeId, String productId, String productVersion) {
        HashMap<String, String> requestAttributes = new HashMap<String, String>();
        requestAttributes.put(HOST, host);
        requestAttributes.put(PORT, port);
        requestAttributes.put(USER, "12345678");
        requestAttributes.put(MODE, modeId);
        requestAttributes.put(PRODUCT, productId);
        requestAttributes.put(VERSION, productVersion);
        return requestAttributes;
    }

    public static URIBuilder createRequestUriBuilder(Map<String, String> attributes) {
        String host = "";
        String port = "";
        String hostAttr = attributes.get(HOST);
        String portAttr = attributes.get(PORT);
        if (!(hostAttr instanceof String)) {
            logger.info("Host value undefined.");
            return null;
        }
        host = hostAttr;
        if (!(portAttr instanceof String)) {
            logger.info("Port value undefined.");
            return null;
        }
        port = portAttr;
        String requestHead = String.format("%s://%s:%s", PROTOCOL_TYPE_ID, host, port);
        try {
            URIBuilder builder = new URIBuilder(requestHead);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey().equals(HOST) || entry.getKey().equals(PORT)) continue;
                builder.setParameter(entry.getKey(), entry.getValue());
            }
            return builder;
        }
        catch (URISyntaxException e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    public static URIBuilder createRequestURI(CloseableHttpClient httpClient, HttpHost host, Map<String, String> attributes, String action) {
        attributes.put(ACTION, action);
        attributes.put(CONTENT_TYPE, "application/xml");
        return LicensingRequests.createRequestUriBuilder(attributes);
    }
}

