/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.base.actions;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.passage.lbc.base.BaseComponent;
import org.eclipse.passage.lbc.runtime.ServerRequestAction;
import org.eclipse.passage.lic.base.LicensingConfigurations;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.conditions.ConditionMiner;
import org.eclipse.passage.lic.runtime.conditions.ConditionTransport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.log.LoggerFactory;

@Component
public class ConditionDescriptorRequestAction
extends BaseComponent
implements ServerRequestAction {
    private static final String SERVER_MINER_TYPE = "server.miner";
    private static final String APPLICATION_JSON = "application/json";
    private static final String LICENSING_CONTENT_TYPE = "licensing.content.type";
    private static final String MINER_TYPE_KEY = "miner.type";
    private List<ConditionMiner> licenseConditionMiners = new ArrayList<ConditionMiner>();
    private Map<String, ConditionTransport> mapCondition2Transport = new HashMap<String, ConditionTransport>();

    public boolean execute(HttpServletRequest request, HttpServletResponse response) {
        ConditionTransport transport;
        ArrayList resultConditions;
        block6: {
            if (this.logger == null) {
                return false;
            }
            this.logger.info(String.format("Executing action request from class: %s", this.getClass().getName()));
            if (this.licenseConditionMiners.isEmpty()) {
                this.logger.error("No condition miners available");
                return false;
            }
            try {
                String productId = request.getParameter("product");
                String productVersion = request.getParameter("version");
                LicensingConfiguration configuration = LicensingConfigurations.create((String)productId, (String)productVersion);
                resultConditions = new ArrayList();
                for (ConditionMiner miner : this.licenseConditionMiners) {
                    Iterable descriptors = miner.extractLicensingConditions(configuration);
                    resultConditions.addAll((Collection)descriptors);
                }
                String contentType = request.getParameter("content.type");
                transport = this.mapCondition2Transport.get(contentType);
                if (transport != null) break block6;
                this.logger.error(String.format("LicensingConditionTransport not defined for contentType: %s", contentType));
                return false;
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
                return false;
            }
        }
        transport.writeConditions(resultConditions, (OutputStream)response.getOutputStream());
        response.setContentType(APPLICATION_JSON);
        return true;
    }

    @Override
    @Reference
    protected void bindLogger(LoggerFactory loggerFactory) {
        super.bindLogger(loggerFactory);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindConditionMiner(ConditionMiner conditionMiner, Map<String, String> context) {
        String minerType = context.get(MINER_TYPE_KEY);
        if (minerType != null && minerType.equals(SERVER_MINER_TYPE)) {
            this.licenseConditionMiners.add(conditionMiner);
        }
    }

    public void unbindConditionMiner(ConditionMiner conditionMiner, Map<String, String> context) {
        this.licenseConditionMiners.remove(conditionMiner);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindConditionTransport(ConditionTransport transport, Map<String, String> context) {
        String conditionType = context.get(LICENSING_CONTENT_TYPE);
        if (conditionType != null) {
            this.mapCondition2Transport.put(conditionType, transport);
        }
    }

    public void unbindConditionTransport(ConditionTransport transport, Map<String, String> context) {
        String conditionType = context.get(LICENSING_CONTENT_TYPE);
        if (conditionType != null) {
            this.mapCondition2Transport.remove(conditionType, transport);
        }
    }
}

