/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.jface.dialogs;

import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class ViewerSearchFilter<T>
extends ViewerFilter {
    protected final Class<T> elementClass;
    protected String searchText = "";

    protected ViewerSearchFilter(Class<T> elementClass) {
        this.elementClass = elementClass;
    }

    public void setFilteringText(String filteringText) {
        this.searchText = filteringText;
    }

    protected Pattern getSearchPattern() {
        Pattern pattern = Pattern.compile(".*" + this.searchText + ".*");
        return pattern;
    }

    protected String getNotNullValue(String text) {
        if (text == null) {
            return "";
        }
        return text;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchText.isEmpty()) {
            return true;
        }
        T converted = this.convertElement(viewer, parentElement, element, this.elementClass);
        if (converted != null) {
            return this.selectElement(viewer, parentElement, converted, this.searchText);
        }
        return false;
    }

    protected T convertElement(Viewer viewer, Object parentElement, Object element, Class<T> elementClass) {
        if (elementClass.isInstance(element)) {
            return elementClass.cast(element);
        }
        return null;
    }

    protected abstract boolean selectElement(Viewer var1, Object var2, T var3, String var4);
}

