/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.io.UserHomeProductResidence;
import org.eclipse.passage.lic.licenses.model.api.LicenseRequisites;
import org.eclipse.passage.loc.internal.api.workspace.LicensePacks;
import org.eclipse.passage.loc.internal.equinox.OperatorGearAware;

final class LicensePackResidence
implements Supplier<Path> {
    private final LicenseRequisites license;

    LicensePackResidence(LicenseRequisites license) {
        this.license = license;
    }

    @Override
    public Path get() {
        return this.existing(this.residence());
    }

    private Path residence() {
        return this.fromWorkspace().orElseGet(this::userHomeResidence);
    }

    private Path userHomeResidence() {
        return new UserHomeProductResidence(this.license.getProduct().getIdentifier(), this.license.getProduct().getVersion()).get().resolve(this.license.getIdentifier());
    }

    private Optional<Path> fromWorkspace() {
        try {
            return new OperatorGearAware().withGear(gear -> Optional.of(this.fromWorkspace(gear.workspace().licensePacks())));
        }
        catch (LicensingException e) {
            return Optional.empty();
        }
    }

    private Path fromWorkspace(LicensePacks service) {
        return Paths.get(service.packResidence(this.license.getIdentifier(), this.license.getProduct().getIdentifier(), this.license.getProduct().getVersion()).uri(), new String[0]);
    }

    private Path existing(Path folder) {
        folder.toFile().mkdirs();
        return folder;
    }
}

