/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.access;

import java.util.Objects;
import org.eclipse.passage.lic.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.api.acquire.GrantAcquisition;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;

abstract class BaseGrantLockAttempt
implements GrantLockAttempt {
    private final ExaminationCertificate certificate;

    protected BaseGrantLockAttempt(ExaminationCertificate certificate) {
        Objects.requireNonNull(certificate, "BaseGrantLock::certificate");
        this.certificate = certificate;
    }

    public ExaminationCertificate certificate() {
        return this.certificate;
    }

    static final class Failed
    extends BaseGrantLockAttempt {
        protected Failed(ExaminationCertificate certificate) {
            super(certificate);
        }

        public boolean successful() {
            return false;
        }

        public GrantAcquisition grant() {
            throw new IllegalStateException("Failed lock is not supposed to supply grant");
        }
    }

    static final class Successful
    extends BaseGrantLockAttempt {
        private final GrantAcquisition grant;

        Successful(ExaminationCertificate certificate, GrantAcquisition grant) {
            super(certificate);
            Objects.requireNonNull(grant, "BaseGrantLock::grant");
            this.grant = grant;
        }

        public boolean successful() {
            return true;
        }

        public GrantAcquisition grant() {
            return this.grant;
        }
    }
}

