/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.base.BaseLicensedProduct;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.base.diagnostic.SumOfLists;
import org.eclipse.passage.lic.base.io.FloatingFileExtension;
import org.eclipse.passage.lic.emf.validation.ErrorMessages;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.api.LicenseRequisites;
import org.eclipse.passage.lic.licenses.model.api.ProductRef;
import org.eclipse.passage.lic.licenses.model.api.UserGrant;
import org.eclipse.passage.loc.internal.agreements.AgreementRegistry;
import org.eclipse.passage.loc.internal.api.IssuedFloatingLicense;
import org.eclipse.passage.loc.internal.api.OperatorProductService;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.licenses.core.BaseIssuedFloatingLicense;
import org.eclipse.passage.loc.internal.licenses.core.ContributedLicensePackIssueListener;
import org.eclipse.passage.loc.internal.licenses.core.LicenseAgreements;
import org.eclipse.passage.loc.internal.licenses.core.LicensePackResidence;
import org.eclipse.passage.loc.internal.licenses.core.LicenseSignature;
import org.eclipse.passage.loc.internal.licenses.core.PersistedDecoded;
import org.eclipse.passage.loc.internal.licenses.core.PersistedEncoded;
import org.eclipse.passage.loc.internal.licenses.core.ProductPassword;
import org.eclipse.passage.loc.internal.licenses.core.UpdateLicensePlan;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;
import org.eclipse.passage.loc.internal.licenses.core.issue.FloatingLicenseIssuingProtection;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.internal.products.core.PublicKeyReplcated;
import org.eclipse.passage.loc.licenses.trouble.code.LicenseAgreementsAttachFailed;
import org.eclipse.passage.loc.licenses.trouble.code.LicenseIssuingFailed;
import org.eclipse.passage.loc.licenses.trouble.code.LicenseValidationFailed;

final class IssueFloatingLicense {
    private final LicenseRegistry licenses;
    private final AgreementRegistry agreements;
    private final ProductRegistry products;
    private final OperatorProductService operator;

    IssueFloatingLicense(LicenseRegistry licenses, AgreementRegistry agreements, ProductRegistry products, OperatorProductService operator) {
        this.licenses = licenses;
        this.agreements = agreements;
        this.products = products;
        this.operator = operator;
    }

    ServiceInvocationResult<IssuedFloatingLicense> issue(FloatingLicensePack pack, Collection<FloatingLicenseAccess> configs) {
        FloatingLicensePack license;
        try {
            license = new Builder(pack, configs).signed().shielded().withAgreements().get();
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseAgreementsAttachFailed(), e.getMessage(), (Exception)((Object)e)));
        }
        try {
            new UpdateLicensePlan(this.licenses).withFloating(license);
        }
        catch (IOException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_error_io, (Exception)e));
        }
        return this.persistLicenseFiles((FloatingLicensePack)EcoreUtil.copy((EObject)license), configs);
    }

    private ServiceInvocationResult<IssuedFloatingLicense> persistLicenseFiles(FloatingLicensePack pack, Collection<FloatingLicenseAccess> configs) {
        LicensedProduct product = this.product(pack.getLicense().getProduct());
        Path residence = new LicensePackResidence((LicenseRequisites)pack.getLicense()).get();
        ServiceInvocationResult<List<Path>> license = this.persist((EObject)pack, product, residence, this.decryptedFile(pack), this.encryptedFile(pack));
        BaseServiceInvocationResult.Sum sum = new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfLists());
        ServiceInvocationResult withConfigs = configs.stream().map(access -> this.persist((EObject)access, product, residence, this.decryptedFile((FloatingLicenseAccess)access), this.encryptedFile((FloatingLicenseAccess)access))).reduce(license, (BinaryOperator<ServiceInvocationResult>)sum);
        ServiceInvocationResult withKey = (ServiceInvocationResult)sum.apply(withConfigs, this.replicateKey(product, residence));
        if (!new NoSevereErrors().test(withKey.diagnostic())) {
            return new BaseServiceInvocationResult(withKey.diagnostic());
        }
        new ContributedLicensePackIssueListener().floating(pack, configs, residence);
        return new BaseServiceInvocationResult((Object)new BaseIssuedFloatingLicense(residence, (List)withKey.data().get()));
    }

    private ServiceInvocationResult<List<Path>> persist(EObject target, LicensedProduct product, Path folder, String decrypted, String encrypted) {
        Path licen;
        Path lic;
        Optional errors = new ErrorMessages().apply(target);
        if (errors.isPresent()) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseValidationFailed(), (String)errors.get()));
        }
        try {
            lic = new PersistedDecoded(folder, target).write(decrypted);
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_floating_save_decoded_failed, (Exception)((Object)e)));
        }
        try {
            licen = new PersistedEncoded(product, lic, new ProductPassword(this.products, this.operator)).write(encrypted);
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_floating_save_encoded_failed, (Exception)((Object)e)));
        }
        return new BaseServiceInvocationResult(Arrays.asList(lic, licen));
    }

    private ServiceInvocationResult<List<Path>> replicateKey(LicensedProduct product, Path folder) {
        Path key;
        try {
            key = new PublicKeyReplcated(product, folder).store();
        }
        catch (Exception e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_floating_save_product_key, e));
        }
        return new BaseServiceInvocationResult(Collections.singletonList(key));
    }

    private LicensedProduct product(ProductRef ref) {
        return new BaseLicensedProduct(ref.getIdentifier(), ref.getVersion());
    }

    private String decryptedFile(FloatingLicensePack pack) {
        return String.valueOf(pack.getLicense().getIdentifier()) + new FloatingFileExtension.FloatingLicenseDecrypted().get();
    }

    private String encryptedFile(FloatingLicensePack pack) {
        return String.valueOf(pack.getLicense().getIdentifier()) + new FloatingFileExtension.FloatingLicenseEncrypted().get();
    }

    private String decryptedFile(FloatingLicenseAccess access) {
        return this.accessFile(access, (FloatingFileExtension)new FloatingFileExtension.FloatingLicenseAccessDecrypted());
    }

    private String encryptedFile(FloatingLicenseAccess access) {
        return this.accessFile(access, (FloatingFileExtension)new FloatingFileExtension.FloatingLicenseAccessEncrypted());
    }

    private String accessFile(FloatingLicenseAccess access, FloatingFileExtension ext) {
        return String.format("%s_%s%s", access.getOriginLicensePack(), access.getUser(), ext.get());
    }

    private final class Builder
    implements Supplier<FloatingLicensePack> {
        private final FloatingLicensePack pack;
        private final Collection<FloatingLicenseAccess> configs;

        Builder(FloatingLicensePack template, Collection<FloatingLicenseAccess> configs) {
            this.pack = (FloatingLicensePack)EcoreUtil.copy((EObject)template);
            this.configs = configs;
        }

        Builder shielded() {
            new FloatingLicenseIssuingProtection().accept(this.pack);
            Collection users = this.pack.getUsers().stream().map(UserGrant::getUser).collect(Collectors.toSet());
            Collection redundant = this.configs.stream().filter(c -> !users.contains(c.getUser())).collect(Collectors.toSet());
            this.configs.removeAll(redundant);
            return this;
        }

        Builder signed() {
            new LicenseSignature().accept((LicenseRequisites)this.pack.getLicense());
            return this;
        }

        Builder withAgreements() throws LicensingException {
            new LicenseAgreements(IssueFloatingLicense.this.agreements).install(this.plan(), (LicenseRequisites)this.pack.getLicense());
            return this;
        }

        @Override
        public FloatingLicensePack get() {
            return this.pack;
        }

        private LicensePlanDescriptor plan() {
            return IssueFloatingLicense.this.licenses.getLicensePlan(this.pack.getLicense().getPlan());
        }
    }
}

