/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.users.core;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserOriginDescriptor;
import org.eclipse.passage.lic.users.model.api.Contact;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.lic.users.model.api.UserOrigin;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.users.core.UserDomainRegistry;

public class UsersDomainRegistryTracker
extends DomainContentAdapter<UserOriginDescriptor, UserDomainRegistry> {
    public UsersDomainRegistryTracker(UserDomainRegistry registry) {
        super((EditingDomainRegistry)registry);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof UserOrigin) {
            UserOrigin userOrigin = (UserOrigin)notifier;
            switch (notification.getFeatureID(UserOrigin.class)) {
                case 0: {
                    this.processUserOriginIdentifier(userOrigin, notification);
                    break;
                }
                case 3: {
                    this.processUserOriginUsers(notification);
                    break;
                }
            }
        } else if (notifier instanceof User) {
            User user = (User)notifier;
            switch (notification.getFeatureID(User.class)) {
                case 0: {
                    this.processUserIdentifier(user, notification);
                    break;
                }
                case 3: {
                    this.processUserContact(user, notification);
                    break;
                }
            }
        } else if (notifier instanceof Contact) {
            Contact contact = (Contact)notifier;
            switch (notification.getFeatureID(Contact.class)) {
                case 3: {
                    this.processContactEmail(contact, notification);
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void processUserOriginIdentifier(UserOrigin userOrigin, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((UserDomainRegistry)this.registry).unregisterUserOrigin(oldValue);
                }
                if (newValue == null) break;
                ((UserDomainRegistry)this.registry).registerUserOrigin((UserOriginDescriptor)userOrigin);
                break;
            }
        }
    }

    protected void processUserOriginUsers(Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                boolean cfr_ignored_0 = newValue instanceof User;
                break;
            }
            case 4: {
                User user;
                String identifier;
                if (!(oldValue instanceof User) || (identifier = (user = (User)oldValue).getIdentifier()) == null) break;
                ((UserDomainRegistry)this.registry).unregisterUser(identifier);
                break;
            }
        }
    }

    protected void processUserIdentifier(User user, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((UserDomainRegistry)this.registry).unregisterUser(oldValue);
                }
                if (newValue == null) break;
                ((UserDomainRegistry)this.registry).registerUser((UserDescriptor)user);
                break;
            }
        }
    }

    protected void processUserContact(User user, Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 1: {
                Contact contact;
                String email;
                if (!(newValue instanceof Contact) || (email = (contact = (Contact)newValue).getEmail()) == null) break;
                ((UserDomainRegistry)this.registry).registerUser((UserDescriptor)user);
                break;
            }
            case 2: {
                Contact contact;
                String email;
                if (!(oldValue instanceof User) || (email = (contact = (Contact)oldValue).getEmail()) == null) break;
                ((UserDomainRegistry)this.registry).unregisterUser(email);
                break;
            }
        }
    }

    protected void processContactEmail(Contact contact, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                EObject eContainer;
                if (oldValue != null) {
                    ((UserDomainRegistry)this.registry).unregisterUser(oldValue);
                }
                if (newValue == null || !((eContainer = contact.eContainer()) instanceof User)) break;
                User user = (User)eContainer;
                ((UserDomainRegistry)this.registry).registerUser((UserDescriptor)user);
                break;
            }
        }
    }
}

