/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.equinox;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.passage.loc.internal.api.OperatorGear;
import org.eclipse.passage.loc.internal.api.OperatorGearSupplier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class OperatorGearAware {
    public <T> Optional<T> withGear(Function<OperatorGear, Optional<T>> with) {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        Collection<Object> references = Collections.emptyList();
        try {
            references = context.getServiceReferences(OperatorGearSupplier.class, null);
        }
        catch (InvalidSyntaxException e) {
            return Optional.empty();
        }
        if (references.isEmpty()) {
            return Optional.empty();
        }
        ServiceReference any = (ServiceReference)references.iterator().next();
        try {
            Optional<T> optional = with.apply(((OperatorGearSupplier)context.getService(any)).gear());
            return optional;
        }
        finally {
            context.ungetService(any);
        }
    }
}

