/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.Field;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.Fields;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.LicenseDataPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.PageFields;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.SwitchableFields;

public final class ComposedPage
implements Supplier<LicenseDataPage> {
    private final String name;
    private final String description;
    private final IEclipseContext context;
    private final List<Fields> blocks = new ArrayList<Fields>();
    private LicenseDataPage page;

    public ComposedPage(String name, String description, IEclipseContext context) {
        this.name = name;
        this.description = description;
        this.context = context;
    }

    public PageFields withBlock() {
        PageFields block = new PageFields(this::page, this.context);
        this.blocks.add(block);
        return block;
    }

    public SwitchableFields withSwitchableBlock(String label, boolean value, Fields dependants) {
        SwitchableFields block = new SwitchableFields(this.context, label, value, dependants);
        this.blocks.add(this.blocks.indexOf(dependants), block);
        return block;
    }

    @Override
    public LicenseDataPage get() {
        this.page = new LicenseDataPage(this.name, this.description, this.units());
        return this.page;
    }

    private List<Field<?>> units() {
        return this.blocks.stream().flatMap(block -> block.fields().stream()).collect(Collectors.toList());
    }

    private LicenseDataPage page() {
        return this.page;
    }
}

