/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl.acquire;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lic.floating.model.api.FloatingLicenseAccess;
import org.eclipse.passage.lic.floating.model.convert.EGrantAcquisition;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.acquire.GrantAcquisition;
import org.eclipse.passage.lic.internal.api.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.internal.api.io.StreamCodecRegistry;
import org.eclipse.passage.lic.internal.emf.EObjectToBytes;
import org.eclipse.passage.lic.internal.hc.remote.Client;
import org.eclipse.passage.lic.internal.hc.remote.Configuration;
import org.eclipse.passage.lic.internal.hc.remote.Connection;
import org.eclipse.passage.lic.internal.hc.remote.ResponseHandler;
import org.eclipse.passage.lic.internal.hc.remote.impl.BaseConfiguration;
import org.eclipse.passage.lic.internal.hc.remote.impl.RemoteRequest;
import org.eclipse.passage.lic.internal.hc.remote.impl.RemoteServiceData;
import org.eclipse.passage.lic.internal.hc.remote.impl.RequestParameters;
import org.eclipse.passage.lic.internal.hc.remote.impl.ResultsTransfered;
import org.eclipse.passage.lic.internal.hc.remote.impl.ServiceAny;
import org.eclipse.passage.lic.internal.hc.remote.impl.acquire.ReleaseRequestParameters;

final class RemoteRelease<C extends Connection>
extends ServiceAny<C, Boolean, RemoteServiceData.WithPayload<GrantAcquisition>> {
    RemoteRelease(KeyKeeperRegistry keys, StreamCodecRegistry codecs, Supplier<Client<C, Boolean>> client, Supplier<Path> source) {
        super(keys, codecs, client, source);
    }

    @Override
    protected RemoteRequest<C> request(RemoteServiceData.WithPayload<GrantAcquisition> params, FloatingLicenseAccess access) {
        return new Request(params, access);
    }

    @Override
    protected ResponseHandler<Boolean> handler(FloatingLicenseAccess access) {
        return new ReleaseResponseHandler();
    }

    private static final class ReleaseResponseHandler
    implements ResponseHandler<Boolean> {
        private ReleaseResponseHandler() {
        }

        @Override
        public Boolean read(ResultsTransfered results) throws LicensingException {
            return results.successful();
        }
    }

    private final class Request
    extends RemoteRequest<C> {
        private final RemoteServiceData.WithPayload<GrantAcquisition> data;

        Request(RemoteServiceData.WithPayload<GrantAcquisition> data, FloatingLicenseAccess access) {
            super(data.product(), access);
            this.data = data;
        }

        @Override
        public Configuration<C> config() throws LicensingException {
            return new BaseConfiguration.Post(this.payload());
        }

        @Override
        public RequestParameters parameters() {
            return new ReleaseRequestParameters(this.product, this.data.payload().feature(), this.access);
        }

        private byte[] payload() throws LicensingException {
            return new EObjectToBytes((EObject)new EGrantAcquisition(this.data.payload()).get()).get();
        }
    }
}

